/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.biojava.bio.gui.sequence.CircularRenderer;
import org.biojava.bio.gui.sequence.CircularRendererContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.SymbolList;

public class CircularRendererPanel
extends JComponent {
    private final CircularRendererContext ctxt = new CTXT();
    private SymbolList symList;
    private double radius;
    private CircularRenderer renderer;
    private double offset;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public SymbolList getSequence() {
        return this.symList;
    }

    public void setSequence(SymbolList symList) {
        this.symList = symList;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public CircularRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CircularRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isActive()) {
            return;
        }
        double depth = this.renderer.getDepth(this.ctxt);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(depth + this.radius, depth + this.radius);
        this.renderer.paint(g2, this.ctxt);
    }

    private boolean isActive() {
        return this.renderer != null;
    }

    private final class CTXT
    implements CircularRendererContext {
        private CTXT() {
        }

        @Override
        public double getOffset() {
            return CircularRendererPanel.this.offset;
        }

        @Override
        public double getAngle(int indx) {
            return (double)indx * 2.0 * Math.PI / (double)CircularRendererPanel.this.symList.length() + CircularRendererPanel.this.offset;
        }

        @Override
        public int getIndex(double angle) {
            return (int)((angle - CircularRendererPanel.this.offset) * (double)CircularRendererPanel.this.symList.length() / (Math.PI * 2));
        }

        @Override
        public double getRadius() {
            return CircularRendererPanel.this.radius;
        }

        @Override
        public SymbolList getSymbols() {
            return CircularRendererPanel.this.symList;
        }

        @Override
        public FeatureHolder getFeatures() {
            if (CircularRendererPanel.this.symList instanceof FeatureHolder) {
                return (FeatureHolder)((Object)CircularRendererPanel.this.symList);
            }
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
    }
}

