/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.biojava.bio.gui.sequence.AbstractBeadRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class EllipticalBeadRenderer
extends AbstractBeadRenderer {
    public static final ChangeType RATIO = new ChangeType("The shape of the features has changed", "org.biojava.bio.gui.sequence.EllipticalBeadRenderer", "RATIO", SequenceRenderContext.LAYOUT);
    protected double dimensionRatio;

    public EllipticalBeadRenderer() {
        this.dimensionRatio = 2.0;
    }

    public EllipticalBeadRenderer(double beadDepth, double beadDisplacement, Paint beadOutline, Paint beadFill, Stroke beadStroke, double dimensionRatio) {
        super(beadDepth, beadDisplacement, beadOutline, beadFill, beadStroke);
        dimensionRatio = 2.0;
    }

    @Override
    public void renderBead(Graphics2D g2, Feature f, SequenceRenderContext context) {
        Ellipse2D.Double shape;
        Location loc = f.getLocation();
        int min = loc.getMin();
        int max = loc.getMax();
        int dif = max - min;
        if (context.getDirection() == 0) {
            double posXW = context.sequenceToGraphics(min);
            double posYN = this.beadDisplacement;
            double width = Math.max((double)(dif + 1) * context.getScale(), 1.0);
            double height = Math.min(this.beadDepth, width / this.dimensionRatio);
            if (height < this.beadDepth) {
                posYN += (this.beadDepth - height) / this.dimensionRatio;
            }
            shape = new Ellipse2D.Double(posXW, posYN, width, height);
        } else {
            double posXW = this.beadDisplacement;
            double posYN = context.sequenceToGraphics(min);
            double height = Math.max(((double)dif + 1.0) * context.getScale(), 1.0);
            double width = Math.min(this.beadDepth, height / this.dimensionRatio);
            if (width < this.beadDepth) {
                posXW += (this.beadDepth - width) / this.dimensionRatio;
            }
            shape = new Ellipse2D.Double(posXW, posYN, width, height);
        }
        g2.setPaint(this.beadFill);
        g2.fill(shape);
        g2.setStroke(this.beadStroke);
        g2.setPaint(this.beadOutline);
        g2.draw(shape);
    }

    @Override
    public double getDepth(SequenceRenderContext context) {
        double maxDepth = super.getDepth(context);
        return Math.max(maxDepth, this.beadDepth + this.beadDisplacement);
    }

    public double getDimensionRatio() {
        return this.dimensionRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensionRatio(double ratio) throws ChangeVetoException {
        if (ratio < 1.0) {
            throw new ChangeVetoException("The long dimension may not be less than the short dimension (ratio >= 1.0)");
        }
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, RATIO, new Double(this.dimensionRatio), new Double(ratio)));
                cs.firePreChangeEvent(ce);
                this.dimensionRatio = ratio;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.dimensionRatio = ratio;
        }
    }
}

