/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheMap;
import org.biojava.utils.cache.FixedSizeMap;

public class FilteringRenderer
extends SequenceRendererWrapper {
    public static ChangeType FILTER = new ChangeType("The filter has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "FILTER", SequenceRenderContext.LAYOUT);
    public static ChangeType RECURSE = new ChangeType("The recurse flag has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "RECURSE", SequenceRenderContext.LAYOUT);
    protected FeatureFilter filter;
    protected boolean recurse;
    private CacheMap contextCache = new FixedSizeMap(500);
    private Set flushers = new HashSet();

    @Override
    protected boolean hasListeners() {
        return super.hasListeners();
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        return super.getChangeSupport(ct);
    }

    public FilteringRenderer() {
        this.filter = FeatureFilter.all;
        this.recurse = false;
    }

    public FilteringRenderer(SequenceRenderer renderer, FeatureFilter filter, boolean recurse) {
        super(renderer);
        try {
            this.setFilter(filter);
            this.setRecurse(recurse);
        }
        catch (ChangeVetoException cve) {
            throw new AssertionFailure("Assertion Failure: Should have no listeners", cve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(FeatureFilter filter) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(FILTER);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, FILTER, this.filter, filter);
                cs.firePreChangeEvent(ce);
                this.filter = filter;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.filter = filter;
        }
    }

    public FeatureFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecurse(boolean recurse) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(RECURSE);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, RECURSE, new Boolean(recurse), new Boolean(this.recurse));
                cs.firePreChangeEvent(ce);
                this.recurse = recurse;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.recurse = recurse;
        }
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    @Override
    public double getDepth(SequenceRenderContext src) {
        return super.getDepth(this.getContext(src));
    }

    @Override
    public double getMinimumLeader(SequenceRenderContext src) {
        return super.getMinimumLeader(this.getContext(src));
    }

    @Override
    public double getMinimumTrailer(SequenceRenderContext src) {
        return super.getMinimumTrailer(this.getContext(src));
    }

    @Override
    public void paint(Graphics2D g, SequenceRenderContext src) {
        super.paint(g, this.getContext(src));
    }

    @Override
    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        return super.processMouseEvent(this.getContext(src), me, path);
    }

    protected SequenceRenderContext getContext(SequenceRenderContext src) {
        FeatureFilter.And actual = new FeatureFilter.And(this.filter, new FeatureFilter.OverlapsLocation(src.getRange()));
        CtxtFilt gopher = new CtxtFilt(src, actual, this.recurse);
        SequenceRenderContext subSrc = (SequenceRenderContext)this.contextCache.get(gopher);
        if (subSrc == null) {
            subSrc = new SubSequenceRenderContext(src, null, src.getFeatures().filter(actual, this.recurse), null);
            this.contextCache.put(gopher, subSrc);
            CacheFlusher cf = new CacheFlusher(gopher);
            src.getSymbols().addChangeListener(cf, FeatureHolder.FEATURES);
            this.flushers.add(cf);
        }
        return subSrc;
    }

    public String toString() {
        return "FilteringRenderer(" + this.filter + ", " + this.recurse + ", " + this.getRenderer() + ")";
    }

    private class CtxtFilt {
        private SequenceRenderContext src;
        private FeatureFilter filter;
        private boolean recurse;

        public CtxtFilt(SequenceRenderContext src, FeatureFilter filter, boolean recurse) {
            this.src = src;
            this.filter = filter;
            this.recurse = recurse;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CtxtFilt)) {
                return false;
            }
            CtxtFilt that = (CtxtFilt)o;
            return this.src.equals(that.src) && this.filter.equals(that.filter) && this.recurse == that.recurse;
        }

        public int hashCode() {
            return this.src.hashCode() ^ this.filter.hashCode();
        }
    }

    private class CacheFlusher
    implements ChangeListener {
        private CtxtFilt ctxtFilt;

        public CacheFlusher(CtxtFilt ctxtFilt) {
            this.ctxtFilt = ctxtFilt;
        }

        @Override
        public void preChange(ChangeEvent ce) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postChange(ChangeEvent ce) {
            FilteringRenderer.this.contextCache.remove(this.ctxtFilt);
            FilteringRenderer.this.flushers.remove(this);
            if (FilteringRenderer.this.hasListeners()) {
                ChangeSupport cs;
                ChangeSupport changeSupport = cs = FilteringRenderer.this.getChangeSupport(SequenceRenderContext.LAYOUT);
                synchronized (changeSupport) {
                    ChangeEvent ce2 = new ChangeEvent(FilteringRenderer.this, SequenceRenderContext.LAYOUT);
                    cs.firePostChangeEvent(ce2);
                }
            }
        }
    }
}

