/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import org.biojava.bio.gui.sequence.OverlayMarker;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class OverlayRendererWrapper
extends AbstractChangeable
implements SequenceRenderer,
Serializable,
OverlayMarker {
    public static ChangeType RENDERER = new ChangeType("The renderer used to render the filtered features has changed", "org.biojava.bio.gui.sequence.OverlayRendererWrapper", "RENDERER", SequenceRenderContext.LAYOUT);
    private SequenceRenderer renderer;
    private transient ChangeForwarder rendForwarder;

    public OverlayRendererWrapper() {
    }

    public OverlayRendererWrapper(SequenceRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.rendForwarder == null) {
            this.rendForwarder = new SequenceRenderer.RendererForwarder(this, cs);
            if (this.renderer != null && this.renderer instanceof Changeable) {
                Changeable c = (Changeable)((Object)this.renderer);
                c.addChangeListener(this.rendForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderer(SequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERER, renderer, this.renderer);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERER);
            synchronized (changeSupport) {
                Changeable c;
                cs.firePreChangeEvent(ce);
                if (this.renderer != null && this.renderer instanceof Changeable) {
                    c = (Changeable)((Object)this.renderer);
                    c.removeChangeListener(this.rendForwarder);
                }
                this.renderer = renderer;
                if (renderer instanceof Changeable) {
                    c = (Changeable)((Object)renderer);
                    c.removeChangeListener(this.rendForwarder);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.renderer = renderer;
        }
    }

    public SequenceRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public double getDepth(SequenceRenderContext src) {
        SequenceRenderer sr = this.getRenderer();
        if (sr == null) {
            return 0.0;
        }
        return sr.getDepth(src);
    }

    @Override
    public double getMinimumLeader(SequenceRenderContext src) {
        SequenceRenderer sr = this.getRenderer();
        if (sr == null) {
            return 0.0;
        }
        return sr.getMinimumLeader(src);
    }

    @Override
    public double getMinimumTrailer(SequenceRenderContext src) {
        SequenceRenderer sr = this.getRenderer();
        if (sr == null) {
            return 0.0;
        }
        return sr.getMinimumTrailer(src);
    }

    @Override
    public void paint(Graphics2D g, SequenceRenderContext src) {
        SequenceRenderer sr = this.getRenderer();
        if (sr != null) {
            sr.paint(g, src);
        }
    }

    @Override
    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        return this.getRenderer().processMouseEvent(src, me, path);
    }
}

