/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.biojava.bio.gui.sequence.SequencePanel;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.tracklayout.SimpleTrackLayout;
import org.biojava.bio.gui.sequence.tracklayout.TrackLayout;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class SequencePanelWrapper
extends JPanel {
    private RangeLocation range;
    private Sequence sequence;
    private SequencePanel[] seqPanels = new SequencePanel[0];
    private SequenceRenderer renderer;
    private double scale = 14.0;
    private RenderingHints hints;
    private int direction = 0;
    private TrackLayout trackLayout = new SimpleTrackLayout();
    private List viewerListeners = new ArrayList();
    private List motionListeners = new ArrayList();

    public SequencePanelWrapper() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
    }

    public void setTrackLayout(TrackLayout tl) {
        this.trackLayout = tl;
        this.trackLayout.setSequence(this.getSequence());
        this.trackLayout.setRange(this.getRange());
        if (this.isActive()) {
            this.refreshSequencePanels();
        }
    }

    public TrackLayout getTrackLayout() {
        return this.trackLayout;
    }

    protected boolean isActive() {
        return this.sequence != null && this.renderer != null && this.range != null;
    }

    public void setScale(double scale) {
        this.scale = scale;
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].setScale(scale);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].setDirection(direction);
        }
        if (this.isActive()) {
            this.refreshSequencePanels();
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public synchronized void setWrap(int w) {
        this.trackLayout.setWrap(w);
        if (!this.isActive()) {
            return;
        }
        this.refreshSequencePanels();
    }

    public int getWrap() {
        return this.trackLayout.getWrap();
    }

    public void setRenderingHints(RenderingHints hints) {
        this.hints = hints;
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].setRenderingHints(hints);
        }
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderer(SequenceRenderer renderer) {
        this.renderer = renderer;
        for (int i = 0; i < this.seqPanels.length; ++i) {
            try {
                this.seqPanels[i].setRenderer(renderer);
                continue;
            }
            catch (ChangeVetoException e) {
                e.printStackTrace();
            }
        }
    }

    public SequenceRenderer getRenderer() {
        return this.renderer;
    }

    public void setSequence(Sequence seq) {
        if (seq == null) {
            this.removeSeqPanels();
            return;
        }
        this.sequence = seq;
        this.trackLayout.setSequence(this.sequence);
        this.range = new RangeLocation(1, seq.length());
        this.trackLayout.setRange(this.range);
        this.refreshSequencePanels();
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setRange(RangeLocation loc) {
        this.range = loc;
        this.trackLayout.setRange(this.range);
        this.refreshSequencePanels();
    }

    public RangeLocation getRange() {
        return this.range;
    }

    private void removeSeqPanels() {
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.remove(this.seqPanels[i]);
        }
        this.setSize(0, 0);
        this.setLayout(null);
        this.revalidate();
    }

    public void resizeAndValidate() {
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].resizeAndValidate();
        }
    }

    protected void refreshSequencePanels() {
        this.removeSeqPanels();
        RangeLocation[] ranges = this.trackLayout.getRanges();
        this.seqPanels = new SequencePanel[ranges.length];
        if (this.getDirection() == 0) {
            this.setLayout(new BoxLayout(this, 1));
        } else {
            this.setLayout(new BoxLayout(this, 0));
        }
        for (int i = 0; i < ranges.length; ++i) {
            this.seqPanels[i] = new SequencePanel();
            this.seqPanels[i].setFont(this.getFont());
            this.seqPanels[i].setAlignmentX(0.0f);
            this.seqPanels[i].setAlignmentY(0.0f);
            this.seqPanels[i].setSequence(this.getSequence());
            this.seqPanels[i].setRange(new RangeLocation(ranges[i].getMin(), ranges[i].getMax() + 1));
            this.seqPanels[i].setDirection(this.getDirection());
            this.seqPanels[i].setScale(this.getScale());
            Iterator it = this.viewerListeners.iterator();
            while (it.hasNext()) {
                this.seqPanels[i].addSequenceViewerListener((SequenceViewerListener)it.next());
            }
            Iterator jt = this.motionListeners.iterator();
            while (jt.hasNext()) {
                this.seqPanels[i].addSequenceViewerMotionListener((SequenceViewerMotionListener)jt.next());
            }
            this.add(this.seqPanels[i]);
        }
        this.setRenderer(this.getRenderer());
    }

    public void addSequenceViewerListener(SequenceViewerListener l) {
        this.viewerListeners.add(l);
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].addSequenceViewerListener(l);
        }
    }

    public void removeSequenceViewerListener(SequenceViewerListener l) {
        this.viewerListeners.remove(l);
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].removeSequenceViewerListener(l);
        }
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener l) {
        this.motionListeners.add(l);
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].addSequenceViewerMotionListener(l);
        }
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener l) {
        this.motionListeners.remove(l);
        for (int i = 0; i < this.seqPanels.length; ++i) {
            this.seqPanels[i].removeSequenceViewerMotionListener(l);
        }
    }

    @Override
    public void setFont(Font f) {
        try {
            super.setFont(f);
            for (int i = 0; i < this.seqPanels.length; ++i) {
                this.seqPanels[i].setFont(f);
                this.seqPanels[i].resizeAndValidate();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Caught sequence graphics exception in paint() " + e.toString());
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Caught sequence graphics exception in paintComponent() " + e.toString());
            this.repaint();
        }
    }
}

