/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import org.biojava.bio.gui.sequence.LabelRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleLabelRenderer
extends AbstractChangeable
implements LabelRenderer {
    public static final ChangeType LABEL = new ChangeType("The label has changed", "org.biojava.bio.gui.sequence.SimpleLabelRenderer", "LABEL", SequenceRenderContext.LAYOUT);
    private static final AffineTransform FLIP = new AffineTransform(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
    private String label;
    private Shape labelGlyphH;
    private Shape labelGlyphV;

    protected Shape getLabelGlyph(SequenceRenderContext src, FontRenderContext frc) {
        Shape s;
        if (src.getDirection() == 0) {
            if (this.labelGlyphH == null) {
                Font font = src.getFont();
                this.labelGlyphH = font.createGlyphVector(frc, this.label).getOutline();
            }
            s = this.labelGlyphH;
        } else {
            if (this.labelGlyphV == null) {
                Font font = src.getFont().deriveFont(FLIP);
                this.labelGlyphV = font.createGlyphVector(frc, this.label).getOutline();
            }
            s = this.labelGlyphV;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(LABEL);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, LABEL, this.label, label));
                cs.firePreChangeEvent(ce);
                this.label = label;
                this.labelGlyphH = null;
                this.labelGlyphV = null;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.label = label;
            this.labelGlyphH = null;
            this.labelGlyphV = null;
        }
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public double getMinimumWidth(SequenceRenderContext sp) {
        if (this.label == null) {
            return 0.0;
        }
        Font f = sp.getFont();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector gv = f.createGlyphVector(frc, this.label);
        return gv.getVisualBounds().getWidth();
    }

    @Override
    public void paint(Graphics2D g, SequenceRenderContext sp, int min, int max, SequenceRenderContext.Border side) {
    }
}

