/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Font;
import java.awt.geom.Point2D;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class SubSequenceRenderContext
implements SequenceRenderContext {
    private final SequenceRenderContext src;
    private final SymbolList symbols;
    private final FeatureHolder features;
    private final RangeLocation range;
    private final int symOffset;

    public SubSequenceRenderContext(SequenceRenderContext src, SymbolList symbols, FeatureHolder features, RangeLocation range) {
        this(src, symbols, features, range, 0);
    }

    public SubSequenceRenderContext(SequenceRenderContext src, SymbolList symbols, FeatureHolder features, RangeLocation range, int symOffset) {
        this.src = src;
        this.symbols = symbols;
        this.features = features;
        this.range = range;
        this.symOffset = symOffset;
    }

    @Override
    public int getDirection() {
        return this.src.getDirection();
    }

    @Override
    public double getScale() {
        return this.src.getScale();
    }

    @Override
    public double sequenceToGraphics(int i) {
        return this.src.sequenceToGraphics(i + this.symOffset);
    }

    @Override
    public int graphicsToSequence(double d) {
        return this.src.graphicsToSequence(d) - this.symOffset;
    }

    @Override
    public int graphicsToSequence(Point2D point) {
        return this.src.graphicsToSequence(point) - this.symOffset;
    }

    @Override
    public SymbolList getSymbols() {
        if (this.symbols == null) {
            return this.src.getSymbols();
        }
        return this.symbols;
    }

    @Override
    public FeatureHolder getFeatures() {
        if (this.features == null) {
            return this.src.getFeatures();
        }
        return this.features;
    }

    @Override
    public RangeLocation getRange() {
        if (this.range == null) {
            return this.src.getRange();
        }
        return this.range;
    }

    @Override
    public SequenceRenderContext.Border getLeadingBorder() {
        return this.src.getLeadingBorder();
    }

    @Override
    public SequenceRenderContext.Border getTrailingBorder() {
        return this.src.getTrailingBorder();
    }

    @Override
    public Font getFont() {
        return this.src.getFont();
    }
}

