/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class ZiggyFeatureRenderer
extends AbstractChangeable
implements FeatureRenderer,
Serializable {
    private Paint outline = Color.black;
    private Paint fill = Color.yellow;
    private double blockDepth = 10.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFill(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT, p, this.fill);
                cs.firePreChangeEvent(ce);
                this.fill = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.fill = p;
        }
    }

    public Paint getFill() {
        return this.fill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutline(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT);
                cs.firePreChangeEvent(ce);
                this.outline = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.outline = p;
        }
    }

    public Paint getOutline() {
        return this.outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockDepth(double depth) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT);
                cs.firePreChangeEvent(ce);
                this.blockDepth = depth;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.blockDepth = depth;
        }
    }

    public double getBlockDepth() {
        return this.blockDepth;
    }

    @Override
    public double getDepth(SequenceRenderContext src) {
        return this.blockDepth + 1.0;
    }

    @Override
    public void renderFeature(Graphics2D g, Feature f, SequenceRenderContext context) {
        Location loc = f.getLocation();
        Iterator i = loc.blockIterator();
        Location last = null;
        if (i.hasNext()) {
            last = (Location)i.next();
            this.renderLocation(g, last, context);
        }
        while (i.hasNext()) {
            Location next = (Location)i.next();
            this.renderLink(g, f, last, next, context);
            this.renderLocation(g, next, context);
            last = next;
        }
    }

    private void renderLocation(Graphics2D g, Location loc, SequenceRenderContext context) {
        Rectangle2D.Double block = new Rectangle2D.Double();
        double min = context.sequenceToGraphics(loc.getMin());
        double max = context.sequenceToGraphics(loc.getMax() + 1);
        if (context.getDirection() == 0) {
            block.setFrame(min, 0.0, max - min, this.blockDepth);
        } else {
            block.setFrame(0.0, min, this.blockDepth, max - min);
        }
        if (this.fill != null) {
            g.setPaint(this.fill);
            g.fill(block);
        }
        if (this.outline != null) {
            g.setPaint(this.outline);
            g.draw(block);
        }
    }

    private StrandedFeature.Strand getStrand(Feature f) {
        if (f instanceof StrandedFeature) {
            return ((StrandedFeature)f).getStrand();
        }
        FeatureHolder fh = f.getParent();
        if (fh instanceof Feature) {
            return this.getStrand((Feature)fh);
        }
        return StrandedFeature.UNKNOWN;
    }

    private void renderLink(Graphics2D g, Feature f, Location source, Location dest, SequenceRenderContext context) {
        Point2D.Double endP;
        Point2D.Double midP;
        Point2D.Double startP;
        Line2D.Double line = new Line2D.Double();
        double half = this.blockDepth * 0.5;
        if (context.getDirection() == 0) {
            if (this.getStrand(f) == StrandedFeature.NEGATIVE) {
                double start = context.sequenceToGraphics(dest.getMin());
                double end = context.sequenceToGraphics(source.getMax() + 1);
                double mid = (start + end) * 0.5;
                startP = new Point2D.Double(start, half);
                midP = new Point2D.Double(mid, this.blockDepth);
                endP = new Point2D.Double(end, half);
            } else {
                double start = context.sequenceToGraphics(source.getMax() + 1);
                double end = context.sequenceToGraphics(dest.getMin());
                double mid = (start + end) * 0.5;
                startP = new Point2D.Double(start, half);
                midP = new Point2D.Double(mid, 0.0);
                endP = new Point2D.Double(end, half);
            }
        } else if (this.getStrand(f) == StrandedFeature.NEGATIVE) {
            double start = context.sequenceToGraphics(dest.getMin() + 1);
            double end = context.sequenceToGraphics(source.getMax());
            double mid = (start + end) * 0.5;
            startP = new Point2D.Double(half, start);
            midP = new Point2D.Double(this.blockDepth, mid);
            endP = new Point2D.Double(half, end);
        } else {
            double start = context.sequenceToGraphics(source.getMax());
            double end = context.sequenceToGraphics(dest.getMin() + 1);
            double mid = (start + end) * 0.5;
            startP = new Point2D.Double(half, start);
            midP = new Point2D.Double(0.0, mid);
            endP = new Point2D.Double(half, end);
        }
        g.setPaint(this.getOutline());
        line.setLine(startP, midP);
        g.draw(line);
        line.setLine(midP, endP);
        g.draw(line);
    }

    @Override
    public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
        return hits;
    }
}

