/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import java.io.InputStream;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.biojava.bio.BioError;
import org.biojava.bio.molbio.RestrictionEnzyme;
import org.biojava.bio.molbio.RestrictionEnzymeManager;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public class RestrictionEnzymeManagerTest
extends TestCase {
    public RestrictionEnzymeManagerTest(String name) {
        super(name);
    }

    public void testGetAllEnzymes() {
        Set allEnz = RestrictionEnzymeManager.getAllEnzymes();
        RestrictionEnzymeManagerTest.assertEquals((int)40, (int)allEnz.size());
    }

    public void testGetEnzyme() {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        RestrictionEnzymeManagerTest.assertEquals((String)"EcoRI", (String)ecoRI.getName());
        try {
            RestrictionEnzyme invalid = RestrictionEnzymeManager.getEnzyme("xxxx");
            invalid = invalid == null ? null : invalid;
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        RestrictionEnzymeManagerTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testGetIsoschizomers() {
        Set isoAvaI = RestrictionEnzymeManager.getIsoschizomers("AvaI");
        RestrictionEnzymeManagerTest.assertEquals((int)1, (int)isoAvaI.size());
        Set isoAvrI = RestrictionEnzymeManager.getIsoschizomers("AvrI");
        RestrictionEnzymeManagerTest.assertEquals((int)1, (int)isoAvrI.size());
        RestrictionEnzyme avaI = RestrictionEnzymeManager.getEnzyme("AvaI");
        RestrictionEnzyme avrI = RestrictionEnzymeManager.getEnzyme("AvrI");
        RestrictionEnzymeManagerTest.assertTrue((boolean)isoAvaI.contains(avrI));
        RestrictionEnzymeManagerTest.assertTrue((boolean)isoAvrI.contains(avaI));
        try {
            Set invalid = RestrictionEnzymeManager.getIsoschizomers("xxxx");
            invalid = invalid == null ? null : invalid;
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        RestrictionEnzymeManagerTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testGetNCutters() {
        Set all6Cutters = RestrictionEnzymeManager.getNCutters(6);
        RestrictionEnzymeManagerTest.assertEquals((int)29, (int)all6Cutters.size());
        for (RestrictionEnzyme e : all6Cutters) {
            RestrictionEnzymeManagerTest.assertEquals((int)6, (int)e.getRecognitionSite().length());
        }
    }

    public void testGetPatterns() {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        Pattern[] pat = RestrictionEnzymeManager.getPatterns(ecoRI);
        RestrictionEnzymeManagerTest.assertEquals((String)"ga{2}t{2}c", (String)pat[0].pattern());
        RestrictionEnzymeManagerTest.assertEquals((String)"ga{2}t{2}c", (String)pat[1].pattern());
        SymbolList site = null;
        try {
            site = DNATools.createDNA("a");
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Internal error in test");
        }
        RestrictionEnzyme custom = null;
        try {
            custom = new RestrictionEnzyme("custom", site, 1, 1);
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError(iae, "Internal error in test");
        }
        try {
            pat = RestrictionEnzymeManager.getPatterns(custom);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        RestrictionEnzymeManagerTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testGetRecognitionSequence() {
        String recognition = RestrictionEnzymeManager.getRecognitionSequence("EcoRI");
        RestrictionEnzymeManagerTest.assertEquals((String)"G^AATTC", (String)recognition);
    }

    public void testgetSuppliers() {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        String suppliers = RestrictionEnzymeManager.getSuppliers(ecoRI);
        RestrictionEnzymeManagerTest.assertEquals((String)"ABCEFGHIJKLMNOQRSTUVX", (String)suppliers);
    }

    public void testloadEnzymeFile() {
        RestrictionEnzyme hind3;
        String rebaseDataFileName = "org/biojava/bio/molbio/rebase.dat";
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(rebaseDataFileName);
        RestrictionEnzymeManager.loadEnzymeFile(is, true);
        Set re = RestrictionEnzymeManager.getAllEnzymes();
        RestrictionEnzymeManagerTest.assertEquals((int)re.size(), (int)1);
        try {
            hind3 = RestrictionEnzymeManager.getEnzyme("HindIII");
            RestrictionEnzymeManagerTest.assertEquals((String)"HindIII", (String)hind3.getName());
        }
        catch (IllegalArgumentException iae) {
            RestrictionEnzymeManagerTest.fail((String)"IllegalArgumentException not expected");
        }
        is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(rebaseDataFileName);
        RestrictionEnzymeManager.loadEnzymeFile(is, false);
        re = RestrictionEnzymeManager.getAllEnzymes();
        RestrictionEnzymeManagerTest.assertEquals((int)re.size(), (int)2);
        try {
            hind3 = RestrictionEnzymeManager.getEnzyme("HindIII");
            RestrictionEnzymeManagerTest.assertEquals((String)"HindIII", (String)hind3.getName());
            RestrictionEnzyme ecor1 = RestrictionEnzymeManager.getEnzyme("EcoRI");
            RestrictionEnzymeManagerTest.assertEquals((String)"EcoRI", (String)ecor1.getName());
        }
        catch (IllegalArgumentException iae) {
            RestrictionEnzymeManagerTest.fail((String)"IllegalArgumentException not expected");
        }
        rebaseDataFileName = "/org/biojava/bio/molbio/rebase_common.dat";
        is = RestrictionEnzymeManager.class.getResourceAsStream(rebaseDataFileName);
        RestrictionEnzymeManager.loadEnzymeFile(is, false);
    }
}

