/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import junit.framework.TestCase;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.molbio.RestrictionEnzyme;
import org.biojava.bio.molbio.RestrictionEnzymeManager;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public class RestrictionEnzymeTest
extends TestCase {
    public RestrictionEnzymeTest(String name) {
        super(name);
    }

    public void testGetName() throws BioException {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        RestrictionEnzymeTest.assertEquals((String)"EcoRI", (String)ecoRI.getName());
    }

    public void testGetRecognitionSite() throws BioException {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        SymbolList site = ecoRI.getRecognitionSite();
        SymbolList test = null;
        try {
            test = DNATools.createDNA("GAATTC");
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Internal error in test");
        }
        for (int i = 1; i <= site.length(); ++i) {
            RestrictionEnzymeTest.assertEquals((Object)test.symbolAt(i), (Object)site.symbolAt(i));
        }
    }

    public void testIsPalindromic() {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        RestrictionEnzymeTest.assertTrue((boolean)ecoRI.isPalindromic());
        RestrictionEnzyme bsp24I = RestrictionEnzymeManager.getEnzyme("Bsp24I");
        RestrictionEnzymeTest.assertTrue((!bsp24I.isPalindromic() ? 1 : 0) != 0);
    }

    public void testGetCutType() {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        RestrictionEnzymeTest.assertEquals((int)0, (int)ecoRI.getCutType());
        RestrictionEnzyme bsp24I = RestrictionEnzymeManager.getEnzyme("Bsp24I");
        RestrictionEnzymeTest.assertEquals((int)1, (int)bsp24I.getCutType());
    }

    public void testGetDownstreamCut() throws BioException {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        int[] ds = ecoRI.getDownstreamCut();
        RestrictionEnzymeTest.assertEquals((int)1, (int)ds[0]);
        RestrictionEnzymeTest.assertEquals((int)5, (int)ds[1]);
    }

    public void testGetUpstreamCut() throws BioException {
        RestrictionEnzyme bsp24I = RestrictionEnzymeManager.getEnzyme("Bsp24I");
        int[] us = bsp24I.getUpstreamCut();
        RestrictionEnzymeTest.assertEquals((int)8, (int)us[0]);
        RestrictionEnzymeTest.assertEquals((int)13, (int)us[1]);
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        try {
            us = ecoRI.getUpstreamCut();
        }
        catch (BioException be) {
            return;
        }
        RestrictionEnzymeTest.fail((String)"Expected BioException");
    }

    public void testGetDownstreamEndType() throws BioException {
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        RestrictionEnzymeTest.assertEquals((int)1, (int)ecoRI.getDownstreamEndType());
        RestrictionEnzyme apaI = RestrictionEnzymeManager.getEnzyme("ApaI");
        RestrictionEnzymeTest.assertEquals((int)0, (int)apaI.getDownstreamEndType());
        RestrictionEnzyme smaI = RestrictionEnzymeManager.getEnzyme("SmaI");
        RestrictionEnzymeTest.assertEquals((int)2, (int)smaI.getDownstreamEndType());
    }

    public void testGetUpstreamEndType() throws BioException {
        RestrictionEnzyme bsp24I = RestrictionEnzymeManager.getEnzyme("Bsp24I");
        RestrictionEnzymeTest.assertEquals((int)1, (int)bsp24I.getUpstreamEndType());
        RestrictionEnzyme ecoRI = RestrictionEnzymeManager.getEnzyme("EcoRI");
        try {
            ecoRI.getUpstreamEndType();
        }
        catch (BioException be) {
            return;
        }
        RestrictionEnzymeTest.fail((String)"Expected BioException");
    }
}

