/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.molbio.RestrictionEnzyme;
import org.biojava.bio.molbio.RestrictionSiteFinder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.utils.ThreadPool;

public class RestrictionMapper
implements SequenceAnnotator {
    public static final String SITE_FEATURE_SOURCE = "regex";
    public static final String SITE_FEATURE_TYPE = "misc_binding";
    private List restrictionEnzymes = new ArrayList();
    private boolean mapAll = false;
    private ThreadPool threadPool;

    public RestrictionMapper(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public Sequence annotate(Sequence sequence) {
        ViewSequence mapped = new ViewSequence(sequence);
        for (int i = 0; i < this.restrictionEnzymes.size(); ++i) {
            RestrictionEnzyme enzyme = (RestrictionEnzyme)this.restrictionEnzymes.get(i);
            this.threadPool.addRequest(new RestrictionSiteFinder(enzyme, this.mapAll, mapped));
        }
        this.threadPool.waitForThreads();
        return mapped;
    }

    public boolean getMapAll() {
        return this.mapAll;
    }

    public void setMapAll(boolean on) {
        this.mapAll = on;
    }

    public void addEnzyme(RestrictionEnzyme enzyme) {
        if (this.restrictionEnzymes.contains(enzyme)) {
            throw new IllegalArgumentException("RestrictionMapper is already mapping '" + enzyme + "'");
        }
        this.restrictionEnzymes.add(enzyme);
    }

    public void removeEnzyme(RestrictionEnzyme enzyme) {
        if (!this.restrictionEnzymes.contains(enzyme)) {
            throw new IllegalArgumentException("RestrictionMapper is not mapping '" + enzyme + "'");
        }
        this.restrictionEnzymes.remove(enzyme);
    }

    public void clearEnzymes() {
        this.restrictionEnzymes.clear();
    }
}

