/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.blast2html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.biojava.bio.program.blast2html.BlastLikeAlignment;
import org.biojava.bio.program.blast2html.DetailHit;
import org.biojava.bio.program.blast2html.HSP;
import org.biojava.bio.program.blast2html.HSPSummary;
import org.biojava.bio.program.blast2html.HTMLRenderer;
import org.biojava.bio.program.blast2html.HitDescription;
import org.biojava.bio.program.blast2html.HitId;
import org.biojava.bio.program.blast2html.HitSummary;
import org.biojava.bio.program.blast2html.Sequence;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Blast2HTMLHandler
extends DefaultHandler {
    private StringBuffer sb = new StringBuffer();
    private String oProgram;
    private String oVersion;
    private String oQuery;
    private String oDatabase;
    private HitSummary oHitSummary = new HitSummary();
    private HitId oHitId = new HitId();
    private HitDescription oDesc = new HitDescription();
    private DetailHit oDetailHit;
    private HSP oHSP;
    private HSPSummary oHSPSummary;
    private BlastLikeAlignment oAlignment;
    private Sequence oQuerySeq;
    private Sequence oHitSeq;
    private String oRawOutput;
    private boolean inCollection;
    private boolean firstSummary;
    private boolean firstDetail;
    private HTMLRenderer oRenderer;

    public Blast2HTMLHandler(HTMLRenderer poRenderer) {
        this.oHitSummary.oHitId = this.oHitId;
        this.oHitSummary.oDesc = this.oDesc;
        this.oDetailHit = new DetailHit();
        this.oHSP = new HSP();
        this.oHSPSummary = new HSPSummary();
        this.oAlignment = new BlastLikeAlignment();
        this.oQuerySeq = new Sequence();
        this.oHitSeq = new Sequence();
        this.oDetailHit.oHitId = this.oHitId;
        this.oDetailHit.oDesc = this.oDesc;
        this.oHSP.oHSPSummary = this.oHSPSummary;
        this.oHSP.oAlignment = this.oAlignment;
        this.oAlignment.oQuerySeq = this.oQuerySeq;
        this.oAlignment.oHitSeq = this.oHitSeq;
        this.oRawOutput = null;
        this.inCollection = false;
        this.firstSummary = true;
        this.firstDetail = true;
        this.oRenderer = null;
        if (poRenderer == null) {
            throw new IllegalArgumentException("HTMLRenderer cannot be null");
        }
        this.oRenderer = poRenderer;
    }

    @Override
    public void startElement(String poNameSpace, String poElementName, String poQName, Attributes poAtts) throws SAXException {
        if (poElementName.equals("BlastLikeDataSetCollection")) {
            this.inCollection = true;
        }
        if (this.inCollection) {
            if (poElementName.equals("BlastLikeDataSet")) {
                this.oProgram = poAtts.getValue("program");
                this.oVersion = poAtts.getValue("version");
                this.sb.setLength(0);
            } else if (poElementName.equals("HitSummary")) {
                this.oHitSummary.score = poAtts.getValue("score");
                this.oHitSummary.expectValue = poAtts.getValue("expectValue");
                this.oHitSummary.numberOfHSPs = poAtts.getValue("numberOfHSPs");
                this.oHitSummary.numberOfContributingHSPs = poAtts.getValue("numberOfContributingHSPs");
                this.oHitSummary.smallestSumProbability = poAtts.getValue("smallestSumProbability");
                this.oHitSummary.readingFrame = poAtts.getValue("readingFrame");
                this.oHitSummary.numberOfDomains = poAtts.getValue("numberOfDomains");
                if (this.firstSummary) {
                    this.oRenderer.startSummaryTable(this.oHitSummary);
                    this.firstSummary = false;
                }
            } else if (poElementName.equals("HSPCollection")) {
                this.oRenderer.writeCurrentDetail(this.oDetailHit);
            } else if (poElementName.equals("Hit")) {
                if (this.firstDetail) {
                    this.oRenderer.startDetailTable();
                    this.firstDetail = false;
                }
                this.oDetailHit.sequenceLength = poAtts.getValue("sequenceLength");
            } else if (poElementName.equals("HSPSummary")) {
                this.oHSPSummary.percentageIdentity = poAtts.getValue("percentageIdentity");
                this.oHSPSummary.score = poAtts.getValue("score");
                this.oHSPSummary.expectValue = poAtts.getValue("expectValue");
                this.oHSPSummary.alignmentSize = poAtts.getValue("alignmentSize");
                this.oHSPSummary.numberOfIdentities = poAtts.getValue("numberOfIdentities");
                this.oHSPSummary.hitStrand = poAtts.getValue("hitStrand");
                this.oHSPSummary.queryStrand = poAtts.getValue("queryStrand");
                this.oHSPSummary.queryFrame = poAtts.getValue("queryFrame");
                this.oHSPSummary.hitFrame = poAtts.getValue("hitFrame");
                this.oHSPSummary.numberOfPositives = poAtts.getValue("numberOfPositives");
                this.oHSPSummary.percentagePositives = poAtts.getValue("percentagePositives");
                this.oHSPSummary.pValue = poAtts.getValue("pValue");
                this.oHSPSummary.sumPValues = poAtts.getValue("sumPValues");
                this.oHSPSummary.numberOfGaps = poAtts.getValue("numberOfGaps");
            } else if (poElementName.equals("HitId")) {
                this.oHitId.id = poAtts.getValue("id");
                this.oHitId.metaData = poAtts.getValue("metaData");
            } else if (poElementName.equals("HitDescription")) {
                this.sb.setLength(0);
            } else if (poElementName.equals("QuerySequence")) {
                this.oAlignment.oQuerySeq.startPosition = poAtts.getValue("startPosition");
                this.oAlignment.oQuerySeq.stopPosition = poAtts.getValue("stopPosition");
                this.sb.setLength(0);
            } else if (poElementName.equals("MatchConsensus")) {
                this.sb.setLength(0);
            } else if (poElementName.equals("HitSequence")) {
                this.oAlignment.oHitSeq.startPosition = poAtts.getValue("startPosition");
                this.oAlignment.oHitSeq.stopPosition = poAtts.getValue("stopPosition");
                this.sb.setLength(0);
            } else if (poElementName.equals("RawOutput")) {
                this.sb.setLength(0);
            }
        }
    }

    @Override
    public void endElement(String poNameSpace, String poElementName, String poQName) {
        if (poElementName.equals("Header")) {
            this.getQueryIdAndDatabase();
            this.oRenderer.writeTitleAndHeader(this.oProgram, this.oVersion, this.oQuery, this.oDatabase);
        } else if (poElementName.equals("HitDescription")) {
            this.oDesc.hitDescription = this.sb.substring(0);
        } else if (poElementName.equals("Summary")) {
            this.oRenderer.endSummaryTable();
        } else if (poElementName.equals("HitSummary")) {
            this.oRenderer.writeCurrentSummary(this.oHitSummary);
        } else if (poElementName.equals("Detail")) {
            this.oRenderer.endDetailTable();
        } else if (poElementName.equals("RawOutput")) {
            this.oRawOutput = this.sb.substring(0);
        } else if (poElementName.equals("HSPSummary")) {
            this.oHSPSummary.rawOutput = this.oRawOutput;
        } else if (poElementName.equals("QuerySequence")) {
            this.oAlignment.oQuerySeq.seq = this.sb.substring(0);
        } else if (poElementName.equals("MatchConsensus")) {
            this.oAlignment.oConsensus = this.sb.substring(0);
        } else if (poElementName.equals("HitSequence")) {
            this.oAlignment.oHitSeq.seq = this.sb.substring(0);
        } else if (poElementName.equals("HSP")) {
            this.oRenderer.writeCurrentHSP(this.oHSPSummary, this.oAlignment);
        } else if (poElementName.equals("BlastLikeDataSetCollection")) {
            this.reInit();
        }
    }

    @Override
    public void characters(char[] charBuffer, int start, int length) {
        this.sb.append(charBuffer, start, length);
    }

    void reInit() {
        this.inCollection = false;
        this.firstSummary = true;
        this.firstDetail = true;
        this.oRawOutput = null;
        this.sb.setLength(0);
    }

    void getQueryIdAndDatabase() {
        BufferedReader reader = new BufferedReader(new StringReader(this.sb.substring(0)));
        try {
            String oLine;
            while ((oLine = reader.readLine()) != null) {
                int index;
                if (oLine.startsWith("Query=")) {
                    index = oLine.indexOf("=");
                    this.oQuery = oLine.substring(index + 1).trim();
                    continue;
                }
                if (!oLine.startsWith("Database:")) continue;
                index = oLine.indexOf(":");
                this.oDatabase = oLine.substring(index + 1).trim();
                break;
            }
        }
        catch (IOException e) {
            this.printError(e);
        }
    }

    void printError(Exception e) {
        System.out.println(e.getMessage());
        e.printStackTrace();
    }
}

