/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.RawAnnotationSequence;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.distributed.DistDataSource;

class DASAnnotationDistDataSource
implements DistDataSource {
    private URL datasource;
    private DASSequenceDB dummyDB = new DASSequenceDB();

    public URL getURL() {
        return this.datasource;
    }

    public DASAnnotationDistDataSource(URL url) throws BioException {
        this.datasource = url;
    }

    @Override
    public boolean hasSequence(String id) throws BioException {
        return false;
    }

    @Override
    public boolean hasFeatures(String id) throws BioException {
        try {
            this.getFeatures(id, FeatureFilter.all, false);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public FeatureHolder getFeatures(FeatureFilter ff) throws BioException {
        throw new BioException();
    }

    @Override
    public FeatureHolder getFeatures(String id, FeatureFilter ff, boolean recurse) throws BioException {
        RawAnnotationSequence fh;
        try {
            fh = new RawAnnotationSequence(this.dummyDB, this.datasource, id);
        }
        catch (IllegalIDException ex) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        if (!recurse && FilterUtils.areProperSubset(FeatureFilter.all, ff)) {
            return fh;
        }
        return fh.filter(ff, recurse);
    }

    @Override
    public Sequence getSequence(String id) throws BioException {
        throw new BioException("Erk");
    }

    @Override
    public Set ids(boolean topLevel) throws BioException {
        return Collections.EMPTY_SET;
    }

    public boolean equals(Object o) {
        if (o instanceof DASAnnotationDistDataSource) {
            return ((DASAnnotationDistDataSource)o).getURL().equals(this.getURL());
        }
        return false;
    }

    public int hashCode() {
        return this.getURL().hashCode() + 5;
    }
}

