/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASSequenceI;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.program.das.Segment;
import org.biojava.bio.program.das.TypesListener;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.CacheReference;

class DASFeatureSet
extends Unchangeable
implements FeatureHolder {
    private FeatureRequestManager.Ticket[] featureTickets;
    private Location[] tiles;
    private CacheReference[] tileFeatures;
    private SimpleFeatureHolder unrulyFeatures = new SimpleFeatureHolder();
    private FeatureHolder allFeatures;
    private Map typesMap;
    private FeatureRequestManager.Ticket typesTicket;
    private FeatureFilter allTypesFilter;
    private DASSequenceI refSequence;
    private URL dataSource;
    private String sourceID;
    private static final int TILE_THRESHOLD_LENGTH = 1000000;
    private static final int TILE_THRESHOLD_COUNT = 2000;
    private static final int TILE_SIZE = 100000;

    DASFeatureSet(DASSequenceI seq, URL ds, String id) throws BioException {
        this.refSequence = seq;
        this.dataSource = ds;
        this.sourceID = id;
    }

    private Map getTypesMap() {
        if (this.typesMap == null) {
            if (this.typesTicket == null) {
                FeatureRequestManager frm = this.refSequence.getParentDB().getFeatureRequestManager();
                this.typesTicket = frm.requestTypes(this.dataSource, new Segment(this.refSequence.getName()), new DASTypesPopulator());
            }
            try {
                this.typesTicket.doFetch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    Set allTypes = DAS.getTypes(this.dataSource);
                    this.typesMap = new HashMap();
                    for (String type : allTypes) {
                        this.typesMap.put(type, null);
                    }
                }
                catch (BioException ex2) {
                    throw new BioRuntimeException("Types command isn't working AT ALL!", ex2);
                }
            }
        }
        if (this.typesMap == null) {
            throw new BioError("Assertion failure: types fetch hasn't happened yet");
        }
        return this.typesMap;
    }

    private FeatureFilter getAllTypesFilter() {
        if (this.allTypesFilter == null) {
            this.allTypesFilter = FeatureFilter.all;
            if (this.refSequence.length() > 1000000) {
                Map typesMap = this.getTypesMap();
                for (String type : typesMap.keySet()) {
                    FeatureFilter.ByType typeFilter = new FeatureFilter.ByType(type);
                    if (this.allTypesFilter == FeatureFilter.all) {
                        this.allTypesFilter = typeFilter;
                        continue;
                    }
                    this.allTypesFilter = new FeatureFilter.Or(this.allTypesFilter, typeFilter);
                }
            }
        }
        return this.allTypesFilter;
    }

    private Location[] getTiles() {
        if (this.tiles == null) {
            boolean doTiling = false;
            int seqLength = this.refSequence.length();
            if (seqLength > 1000000) {
                Map types = this.getTypesMap();
                int totalCount = 0;
                for (Integer count : types.values()) {
                    if (count != null) {
                        totalCount += count.intValue();
                        continue;
                    }
                    doTiling = true;
                }
                if (!doTiling) {
                    boolean bl = doTiling = totalCount > 2000;
                }
            }
            if (doTiling) {
                int numTiles = (int)Math.ceil(1.0 * (double)seqLength / 100000.0);
                this.tiles = new Location[numTiles];
                this.featureTickets = new FeatureRequestManager.Ticket[numTiles];
                this.tileFeatures = new CacheReference[numTiles];
                for (int i = 0; i < numTiles; ++i) {
                    this.tiles[i] = new RangeLocation(i * 100000 + 1, Math.min((i + 1) * 100000 + 1, seqLength));
                }
            } else {
                this.tiles = new Location[1];
                this.tiles[0] = new RangeLocation(1, seqLength);
            }
            this.featureTickets = new FeatureRequestManager.Ticket[this.tiles.length];
            this.tileFeatures = new CacheReference[this.tiles.length];
        }
        return this.tiles;
    }

    private void registerFeatureFetcher(int tileNum, Object regKey) {
        Location[] tiles = this.getTiles();
        if (this.tileFeatures[tileNum] == null || this.tileFeatures[tileNum].get() == null) {
            if (this.featureTickets[tileNum] == null) {
                DASFeatureSetPopulator listener = new DASFeatureSetPopulator(tileNum);
                FeatureRequestManager frm = this.refSequence.getParentDB().getFeatureRequestManager();
                this.featureTickets[tileNum] = tiles.length > 1 ? frm.requestFeatures(this.dataSource, this.sourceID, listener, tiles[tileNum]) : frm.requestFeatures(this.dataSource, this.sourceID, listener);
            }
            if (regKey != null) {
                this.featureTickets[tileNum].setFetchGroup(regKey);
            }
        }
    }

    void registerFeatureFetcher(Location loc, Object regKey) {
        Location[] tiles = this.getTiles();
        for (int t = 0; t < tiles.length; ++t) {
            if (!LocationTools.overlaps(tiles[t], loc)) continue;
            this.registerFeatureFetcher(t, regKey);
        }
    }

    void registerFeatureFetcher(Object regKey) {
        Location[] tiles = this.getTiles();
        for (int t = 0; t < tiles.length; ++t) {
            this.registerFeatureFetcher(t, regKey);
        }
    }

    protected FeatureHolder getFeatures() {
        if (this.allFeatures == null) {
            Location[] tiles = this.getTiles();
            if (tiles.length == 1) {
                this.allFeatures = new TileFeaturesWrapper(0);
            } else {
                try {
                    MergeFeatureHolder mfhAllFeatures = new MergeFeatureHolder();
                    for (int t = 0; t < tiles.length; ++t) {
                        mfhAllFeatures.addFeatureHolder(new TileFeaturesWrapper(t));
                    }
                    mfhAllFeatures.addFeatureHolder(this.unrulyFeatures);
                    this.allFeatures = mfhAllFeatures;
                }
                catch (ChangeVetoException cve) {
                    throw new BioError(cve);
                }
            }
        }
        return this.allFeatures;
    }

    @Override
    public Iterator features() {
        return this.getFeatures().features();
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.filter(ff, !FilterUtils.areProperSubset(ff, FeatureFilter.top_level));
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, this.getSchema())) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getFeatures().filter(ff, recurse);
    }

    @Override
    public FeatureFilter getSchema() {
        FeatureFilter.And baseFilter = new FeatureFilter.And(new FeatureFilter.ByAnnotation("org.biojava.bio.program.das.annotation_server", this.dataSource), this.getAllTypesFilter());
        return new FeatureFilter.And(baseFilter, new FeatureFilter.Or(new FeatureFilter.ByDescendant(baseFilter), FeatureFilter.top_level));
    }

    @Override
    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    @Override
    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    private class TileFeaturesWrapper
    extends Unchangeable
    implements FeatureHolder {
        private int tileNum;

        TileFeaturesWrapper(int tileNum) {
            this.tileNum = tileNum;
        }

        protected FeatureHolder getFeatures() {
            FeatureHolder fh;
            if (DASFeatureSet.this.tileFeatures[this.tileNum] != null && (fh = (FeatureHolder)DASFeatureSet.this.tileFeatures[this.tileNum].get()) != null) {
                return fh;
            }
            DASFeatureSet.this.registerFeatureFetcher(this.tileNum, null);
            try {
                DASFeatureSet.this.featureTickets[this.tileNum].doFetch();
            }
            catch (Exception ex) {
                throw new BioRuntimeException(ex);
            }
            if (DASFeatureSet.this.tileFeatures[this.tileNum] != null && (fh = (FeatureHolder)DASFeatureSet.this.tileFeatures[this.tileNum].get()) != null) {
                return fh;
            }
            throw new BioRuntimeException("Feature fetch failed for now good reason...");
        }

        @Override
        public int countFeatures() {
            return this.getFeatures().countFeatures();
        }

        @Override
        public Iterator features() {
            return this.getFeatures().features();
        }

        @Override
        public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
            return this.getFeatures().filter(ff, recurse);
        }

        @Override
        public FeatureHolder filter(FeatureFilter ff) {
            return this.getFeatures().filter(ff);
        }

        @Override
        public Feature createFeature(Feature.Template templ) throws ChangeVetoException {
            throw new ChangeVetoException("NO");
        }

        @Override
        public void removeFeature(Feature f) throws ChangeVetoException {
            throw new ChangeVetoException("NO");
        }

        @Override
        public boolean containsFeature(Feature f) {
            return this.getFeatures().containsFeature(f);
        }

        @Override
        public FeatureFilter getSchema() {
            FeatureFilter.ContainedByLocation tileFilter = new FeatureFilter.ContainedByLocation(DASFeatureSet.this.tiles[this.tileNum]);
            return new FeatureFilter.And(tileFilter, new FeatureFilter.OnlyDescendants(tileFilter));
        }
    }

    private class DASFeatureSetPopulator
    extends SeqIOAdapter {
        private SimpleFeatureHolder holder;
        private List featureStack = new ArrayList();
        private Feature stackTop = null;
        private int thisTile;
        private Location tileLocation = null;

        DASFeatureSetPopulator(int thisTile) {
            this.thisTile = thisTile;
            Location[] tiles = DASFeatureSet.this.getTiles();
            if (tiles.length > 1) {
                this.tileLocation = tiles[thisTile];
            }
        }

        @Override
        public void startSequence() {
            this.holder = new SimpleFeatureHolder();
        }

        @Override
        public void endSequence() {
            ((DASFeatureSet)DASFeatureSet.this).tileFeatures[this.thisTile] = DASFeatureSet.this.refSequence.getParentDB().getFeaturesCache().makeReference(this.holder);
            ((DASFeatureSet)DASFeatureSet.this).featureTickets[this.thisTile] = null;
        }

        @Override
        public void startFeature(Feature.Template temp) throws ParseException {
            if (temp instanceof ComponentFeature.Template) {
                this.featureStack.add(null);
            } else {
                try {
                    Feature f = null;
                    if (temp.annotation == Annotation.EMPTY_ANNOTATION) {
                        temp.annotation = new SmallAnnotation();
                    } else if (temp.annotation.containsProperty("org.biojava.bio.program.xff.id")) {
                        temp.annotation.setProperty("org.biojava.bio.program.das.feature_id", temp.annotation.getProperty("org.biojava.bio.program.xff.id"));
                    }
                    temp.annotation.setProperty("org.biojava.bio.program.das.annotation_server", DASFeatureSet.this.dataSource);
                    if (this.stackTop == null) {
                        f = DASFeatureSet.this.refSequence.realizeFeature(DASFeatureSet.this.refSequence, temp);
                        if (this.tileLocation == null || LocationTools.contains(this.tileLocation, f.getLocation())) {
                            this.holder.addFeature(f);
                        } else if (!DASFeatureSet.this.unrulyFeatures.containsFeature(f)) {
                            DASFeatureSet.this.unrulyFeatures.addFeature(f);
                        }
                    } else {
                        f = this.stackTop.createFeature(temp);
                    }
                    this.featureStack.add(f);
                    this.stackTop = f;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ParseException(ex, "Couldn't realize feature in DAS");
                }
            }
        }

        @Override
        public void addFeatureProperty(Object key, Object value) throws ParseException {
            if (this.stackTop == null) {
                return;
            }
            try {
                if (key.equals("org.biojava.bio.program.xff.id")) {
                    this.stackTop.getAnnotation().setProperty("org.biojava.bio.program.das.feature_id", value);
                } else {
                    Annotation ann = this.stackTop.getAnnotation();
                    if (ann.containsProperty(key)) {
                        ArrayList<Object> col;
                        Object o = ann.getProperty(key);
                        if (o instanceof Collection) {
                            col = (ArrayList<Object>)o;
                        } else {
                            col = new ArrayList<Object>();
                            col.add(o);
                            ann.setProperty(key, col);
                        }
                        col.add(value);
                    } else {
                        this.stackTop.getAnnotation().setProperty(key, value);
                    }
                }
            }
            catch (ChangeVetoException ex) {
                throw new ParseException(ex, "Couldn't set feature property");
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void endFeature() throws ParseException {
            if (this.featureStack.size() < 1) {
                throw new BioError("Missmatched endFeature()");
            }
            this.featureStack.remove(this.featureStack.size() - 1);
            int pos = this.featureStack.size() - 1;
            this.stackTop = null;
            while (this.stackTop == null && pos >= 0) {
                this.stackTop = (Feature)this.featureStack.get(pos--);
            }
        }
    }

    private class DASTypesPopulator
    implements TypesListener {
        private Map types;

        private DASTypesPopulator() {
        }

        @Override
        public void startSegment() {
            this.types = new HashMap();
        }

        @Override
        public void registerType(String type) {
            this.types.put(type, null);
        }

        @Override
        public void registerType(String type, int count) {
            this.types.put(type, new Integer(count));
        }

        @Override
        public void endSegment() {
            DASFeatureSet.this.typesMap = this.types;
        }
    }
}

