/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import org.biojava.bio.program.das.DASLink;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.program.xff.XFFPartHandlerFactory;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DASLinkHandler
extends StAXContentHandlerBase {
    public static final XFFPartHandlerFactory LINKDETAIL_HANDLER_FACTORY = new XFFPartHandlerFactory(){

        @Override
        public StAXContentHandler getPartHandler(XFFFeatureSetHandler xffenv) {
            return new DASLinkHandler(xffenv);
        }
    };
    private XFFFeatureSetHandler xffenv;
    private int level = 0;

    public DASLinkHandler(XFFFeatureSetHandler xffenv) {
        this.xffenv = xffenv;
    }

    @Override
    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        ++this.level;
        if (this.level == 2 && localName.equals("link")) {
            String url = attrs.getValue("http://www.w3.org/1999/xlink", "href");
            String role = attrs.getValue("http://www.w3.org/1999/xlink", "role");
            if (url != null) {
                try {
                    this.xffenv.getFeatureListener().addFeatureProperty("org.biojava.bio.program.das.links", new DASLink(url, role));
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    throw new SAXException(ex);
                }
            }
        }
    }

    @Override
    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) {
        --this.level;
    }
}

