/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.program.das.Fetcher;
import org.biojava.bio.program.das.Segment;
import org.biojava.bio.program.das.TypesListener;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class TypesFetcher
implements Fetcher {
    private HashMap ticketsBySegment;
    private List doneTickets = Collections.EMPTY_LIST;
    private String category;
    private String type;
    private URL dataSource;
    private TypesListener nullSegmentHandler;

    TypesFetcher(URL dataSource, String type, String category) {
        this.ticketsBySegment = new HashMap();
        this.dataSource = dataSource;
        this.type = type;
        this.category = category;
    }

    @Override
    public URL getDataSourceURL() {
        return this.dataSource;
    }

    @Override
    public void addTicket(FeatureRequestManager.Ticket ticket) {
        this.ticketsBySegment.put(ticket.getSegment(), ticket);
    }

    @Override
    public int size() {
        return this.ticketsBySegment.size();
    }

    @Override
    public List getDoneTickets() {
        return this.doneTickets;
    }

    public void setNullSegmentHandler(TypesListener tl) {
        this.nullSegmentHandler = tl;
    }

    @Override
    public void runFetch() throws BioException, ParseException {
        DAS.startedActivity(this);
        URL fURL = null;
        try {
            HttpURLConnection huc = null;
            Set segmentObjs = this.ticketsBySegment.keySet();
            StringBuffer sb = new StringBuffer();
            Iterator i = segmentObjs.iterator();
            while (i.hasNext()) {
                Object seg = i.next();
                sb.append("segment=");
                Segment segment = (Segment)seg;
                sb.append(segment.getID());
                if (segment.isBounded()) {
                    sb.append(':');
                    sb.append(segment.getStart());
                    sb.append(',');
                    sb.append(segment.getStop());
                }
                if (!i.hasNext()) continue;
                sb.append(';');
            }
            String segments = sb.substring(0);
            String encodingRequest = "";
            String typeRequest = "";
            if (this.type != null) {
                typeRequest = "type=" + this.type + ";";
            }
            String categoryRequest = "";
            if (this.category != null) {
                categoryRequest = "category=" + this.category + ";";
            }
            String queryString = encodingRequest + categoryRequest + typeRequest + segments;
            fURL = new URL(this.dataSource, "types");
            huc = (HttpURLConnection)fURL.openConnection();
            if (queryString.length() > 0) {
                huc.setRequestMethod("POST");
                huc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                huc.setRequestProperty("Accept-Encoding", "gzip");
                huc.setDoOutput(true);
                OutputStream os = huc.getOutputStream();
                PrintStream ps = new PrintStream(os);
                ps.print(queryString);
                ps.close();
            } else {
                huc.setRequestProperty("Accept-Encoding", "gzip");
            }
            huc.connect();
            int status = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
            if (status == 0) {
                throw new BioRuntimeException("Not a DAS server: " + fURL.toString());
            }
            if (status != 200) {
                throw new BioRuntimeException("DAS error (status code = " + status + ") fetching " + fURL.toString() + " with query " + queryString);
            }
            String contentEncoding = huc.getContentEncoding();
            InputStream inStream = huc.getInputStream();
            if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
                inStream = new GZIPInputStream(inStream);
            }
            InputSource is = new InputSource(inStream);
            is.setSystemId(fURL.toString());
            DASTypesHandler dfh = new DASTypesHandler(this.ticketsBySegment, this);
            XMLReader parser = DASSequence.nonvalidatingSAXParser();
            parser.setContentHandler(new SAX2StAXAdaptor(dfh));
            parser.parse(is);
            this.doneTickets = dfh.getDoneTickets();
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        catch (SAXException ex) {
            throw new ParseException(ex, "Error parsing XML from " + fURL);
        }
        finally {
            DAS.completedActivity(this);
        }
    }

    private class DASSegmentHandler
    extends StAXContentHandlerBase {
        private TypesListener tl;
        private int level = 0;

        public DASSegmentHandler(TypesListener tl) {
            this.tl = tl;
        }

        @Override
        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            ++this.level;
            if (this.level == 1) {
                this.tl.startSegment();
            } else if (localName.equals("TYPE")) {
                final String typeId = attrs.getValue("id");
                dm.delegate(new StringElementHandlerBase(){

                    @Override
                    protected void setStringValue(String s) {
                        String count = s.trim();
                        if (count.length() > 0) {
                            try {
                                DASSegmentHandler.this.tl.registerType(typeId, Integer.parseInt(count));
                                return;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        DASSegmentHandler.this.tl.registerType(typeId);
                    }
                });
            } else {
                throw new SAXException("Unexpected element in DASTYPES: " + localName);
            }
        }

        @Override
        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            if (this.level == 1) {
                this.tl.endSegment();
            }
            --this.level;
        }
    }

    private class DASTypesHandler
    extends StAXContentHandlerBase {
        private boolean inDocument = false;
        private Map ticketsBySegment;
        private FeatureRequestManager.Ticket thisTicket;
        private List doneTickets = new ArrayList();
        private Object trigger;

        public List getDoneTickets() {
            return this.doneTickets;
        }

        public DASTypesHandler(Map ticketsBySegment, Object trigger) {
            this.ticketsBySegment = ticketsBySegment;
            this.trigger = trigger;
        }

        @Override
        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (!this.inDocument) {
                this.inDocument = true;
            } else if (localName.equals("SEGMENT")) {
                if (TypesFetcher.this.nullSegmentHandler != null) {
                    dm.delegate(new DASSegmentHandler(TypesFetcher.this.nullSegmentHandler));
                } else {
                    String segID = attrs.getValue("id");
                    if (segID == null) {
                        throw new SAXException("Missing segment ID");
                    }
                    Segment seg = new Segment(segID);
                    this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                    if (this.thisTicket == null) {
                        int start = Integer.parseInt(attrs.getValue("start"));
                        int stop = Integer.parseInt(attrs.getValue("stop"));
                        seg = new Segment(segID, start, stop);
                        this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                        if (this.thisTicket == null) {
                            throw new SAXException("Response segment " + segID + ":" + start + "," + stop + " wasn't requested");
                        }
                        segID = segID + ":" + start + "," + stop;
                    }
                    this.ticketsBySegment.remove(seg);
                    dm.delegate(new DASSegmentHandler(((FeatureRequestManager.TypeTicket)this.thisTicket).getTypesListener()));
                }
            } else if (localName.equals("segmentNotAnnotated") || localName.equals("SEGMENTUNKNOWN")) {
                String segID = attrs.getValue("id");
                if (segID == null) {
                    throw new SAXException("Missing segment ID");
                }
                Segment seg = new Segment(segID);
                this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                if (this.thisTicket == null) {
                    int start = Integer.parseInt(attrs.getValue("start"));
                    int stop = Integer.parseInt(attrs.getValue("stop"));
                    seg = new Segment(segID, start, stop);
                    this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                    if (this.thisTicket == null) {
                        throw new SAXException("Response segment " + segID + ":" + start + "," + stop + " wasn't requested");
                    }
                }
                this.ticketsBySegment.remove(seg);
                TypesListener siol = ((FeatureRequestManager.TypeTicket)this.thisTicket).getTypesListener();
                siol.startSegment();
                siol.endSegment();
                this.thisTicket.setAsFetched();
                this.doneTickets.add(this.thisTicket);
            } else if (localName.equals("segmentError") || localName.equals("SEGMENTERROR")) {
                String segID = attrs.getValue("id");
                String segError = attrs.getValue("error");
                throw new SAXException("Error " + segError + " fetching " + segID);
            }
        }

        @Override
        public void endTree() throws SAXException {
            for (Map.Entry me : this.ticketsBySegment.entrySet()) {
                Segment seg = (Segment)me.getKey();
                System.err.println("*** Not got anything back for segment " + seg.toString());
                TypesListener siol = ((FeatureRequestManager.TypeTicket)me.getValue()).getTypesListener();
                siol.startSegment();
                siol.endSegment();
            }
        }

        @Override
        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            if (localName.equals("SEGMENT") && this.thisTicket != null) {
                this.thisTicket.setAsFetched();
                this.doneTickets.add(this.thisTicket);
                DAS.activityProgress(this.trigger, this.doneTickets.size(), this.ticketsBySegment.size());
            }
        }
    }
}

