/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.program.das.dasalignment.Alignment;
import org.biojava.bio.program.das.dasalignment.DASException;
import org.biojava.bio.program.ssbind.AnnotationFactory;
import org.biojava.bio.structure.AtomImpl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DASAlignmentXMLResponseParser
extends DefaultHandler {
    ArrayList alignments;
    Alignment alignment = new Alignment();
    HashMap current_object;
    String current_position = "start";
    HashMap current_block;
    HashMap current_segment;
    ArrayList segments;
    ArrayList vectors;
    ArrayList matrices;
    String current_detailProperty = "";
    String intObjectId;
    String cigar = "";
    String txt = "";

    public DASAlignmentXMLResponseParser() {
        this.alignments = new ArrayList();
        this.segments = new ArrayList();
        this.vectors = new ArrayList();
        this.matrices = new ArrayList();
    }

    public Alignment[] getAlignments() {
        return this.alignments.toArray(new Alignment[this.alignments.size()]);
    }

    public Alignment getAlignment(int position) {
        Alignment ra = (Alignment)this.alignments.get(position);
        return ra;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equals("alignObject")) {
            this.OBJECThandler(atts);
        }
        if (qName.equals("sequence")) {
            this.SEQUENCEhandler(atts);
        }
        if (qName.equals("score")) {
            this.SCOREhandler(atts);
        }
        if (qName.equals("block")) {
            this.BLOCKhandler(atts);
        }
        if (qName.equals("segment")) {
            this.SEGMENThandler(atts);
        }
        if (qName.equals("cigar")) {
            this.CIGARhandler(atts);
        }
        if (qName.equals("geo3D")) {
            this.GEO3Dhandler(atts);
        }
        if (qName.equals("vector")) {
            this.VECTORhandler(atts);
        }
        if (qName.equals("matrix")) {
            this.MATRIXhandler(atts);
        }
        if (qName.equals("alignObjectDetail")) {
            this.DETAILhandler(atts);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("geo3D")) {
            this.intObjectId = null;
        }
        if (qName.equals("alignObject")) {
            try {
                Annotation oba = AnnotationFactory.makeAnnotation(this.current_object);
                this.alignment.addObject(oba);
            }
            catch (DASException e) {
                e.printStackTrace();
            }
            this.current_object = new HashMap();
            ArrayList details = new ArrayList();
            this.current_object.put("details", details);
        }
        if (qName.equals("segment")) {
            Annotation sega = AnnotationFactory.makeAnnotation(this.current_segment);
            this.segments.add(sega);
            this.current_segment = new HashMap();
        }
        if (qName.equals("block")) {
            try {
                this.current_block.put("segments", this.segments);
                Annotation bloa = AnnotationFactory.makeAnnotation(this.current_block);
                this.alignment.addBlock(bloa);
            }
            catch (DASException e) {
                e.printStackTrace();
            }
            this.current_block = new HashMap();
            this.segments = new ArrayList();
        }
        if (qName.equals("alignment")) {
            this.alignments.add(this.alignment);
            this.alignment = new Alignment();
        }
        if (qName.equals("cigar")) {
            this.cigar = this.cigar.trim();
            this.current_segment.put("cigar", this.cigar);
            this.cigar = "";
        }
        if (qName.equals("alignObjectDetail")) {
            String detailValue = this.txt;
            HashMap<String, String> detail = new HashMap<String, String>();
            detail.put("property", this.current_detailProperty);
            detail.put("detail", detailValue);
            Annotation a = AnnotationFactory.makeAnnotation(detail);
            List details = (List)this.current_object.get("details");
            details.add(a);
            this.current_object.put("details", details);
        }
    }

    private void DETAILhandler(Attributes atts) {
        this.current_detailProperty = atts.getValue("property");
    }

    private void SEGMENThandler(Attributes atts) {
        this.current_position = "segment";
        this.current_segment = new HashMap();
        String id = atts.getValue("intObjectId");
        String start = atts.getValue("start");
        String end = atts.getValue("end");
        this.current_segment.put("intObjectId", id);
        if (start != null) {
            this.current_segment.put("start", start);
        }
        if (end != null) {
            this.current_segment.put("end", end);
        }
    }

    private void CIGARhandler(Attributes atts) {
        this.current_position = "cigar";
        this.cigar = "";
    }

    private void BLOCKhandler(Attributes atts) {
        this.current_block = new HashMap();
        String blockOrder = atts.getValue("blockOrder");
        this.current_block.put("blockOrder", blockOrder);
        try {
            String blockScore = atts.getValue("blockScore");
            if (blockScore != null) {
                this.current_block.put("blockScore", blockScore);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void SEQUENCEhandler(Attributes atts) {
        this.current_position = "sequence";
        String start = atts.getValue("start");
        String end = atts.getValue("end");
        if (start != null) {
            this.current_object.put("seqStart", start);
        }
        if (end != null) {
            this.current_object.put("seqEnd", end);
        }
    }

    private void SCOREhandler(Attributes atts) {
        System.out.println("SCOREhandler not implemented,yet...");
        HashMap<String, String> score = new HashMap<String, String>();
        String metnam = atts.getValue("methodName");
        String value = atts.getValue("value");
        score.put("methodName", metnam);
        score.put("value", value);
        Annotation s = AnnotationFactory.makeAnnotation(score);
        try {
            this.alignment.addScore(s);
        }
        catch (DASException e) {
            e.printStackTrace();
            return;
        }
    }

    private void GEO3Dhandler(Attributes atts) {
        this.intObjectId = atts.getValue("intObjectId");
    }

    private void VECTORhandler(Attributes atts) {
        String xs = atts.getValue("x");
        String ys = atts.getValue("y");
        String zs = atts.getValue("z");
        AtomImpl atom = new AtomImpl();
        atom.setX(Double.parseDouble(xs));
        atom.setY(Double.parseDouble(ys));
        atom.setZ(Double.parseDouble(zs));
        HashMap<String, Object> vector = new HashMap<String, Object>();
        vector.put("intObjectId", this.intObjectId);
        vector.put("vector", atom);
        try {
            Annotation oba = AnnotationFactory.makeAnnotation(vector);
            this.alignment.addVector(oba);
        }
        catch (DASException e) {
            e.printStackTrace();
        }
    }

    private void MATRIXhandler(Attributes atts) {
        HashMap<String, String> matrix = new HashMap<String, String>();
        matrix.put("intObjectId", this.intObjectId);
        for (int x = 1; x <= 3; ++x) {
            for (int y = 1; y <= 3; ++y) {
                String mat = "mat" + x + y;
                String val = atts.getValue(mat);
                matrix.put(mat, val);
            }
        }
        try {
            Annotation oba = AnnotationFactory.makeAnnotation(matrix);
            this.alignment.addMatrix(oba);
        }
        catch (DASException e) {
            e.printStackTrace();
        }
    }

    private void OBJECThandler(Attributes atts) {
        String dbAccessionId = atts.getValue("dbAccessionId");
        String objectVersion = atts.getValue("objectVersion");
        String intObjectId = atts.getValue("intObjectId");
        String type = "";
        try {
            type = atts.getValue("type");
        }
        catch (Exception e) {
            // empty catch block
        }
        String dbSource = atts.getValue("dbSource");
        String dbVersion = atts.getValue("dbVersion");
        String dbCoordSys = atts.getValue("dbCoordSys");
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("dbAccessionId", dbAccessionId);
        object.put("objectVersion", objectVersion);
        object.put("intObjectId", intObjectId);
        ArrayList details = new ArrayList();
        object.put("details", details);
        object.put("dbSource", dbSource);
        if (dbCoordSys != null) {
            object.put("dbCoordSys", dbCoordSys);
        }
        object.put("dbVersion", dbVersion);
        if (type != null) {
            object.put("type", type);
        }
        this.current_object = object;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.txt = "";
        for (int i = start; i < start + length; ++i) {
            this.txt = this.txt + ch[i];
        }
        if (this.current_position == "cigar") {
            this.cigar = this.cigar + this.txt;
        }
        if (this.current_position == "sequence") {
            this.current_object.put("sequence", this.txt);
        }
    }
}

