/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.io.PrintWriter;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFTools;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.StrandedFeature;

public class GFFWriter
implements GFFDocumentHandler {
    private PrintWriter out;

    public GFFWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void startDocument(String locator) {
    }

    @Override
    public void endDocument() {
        this.out.flush();
    }

    @Override
    public void commentLine(String comment) {
        this.out.println("#" + comment);
    }

    @Override
    public void recordLine(GFFRecord record) {
        String comment;
        this.out.print(record.getSeqName() + "\t" + record.getSource() + "\t" + record.getFeature() + "\t" + record.getStart() + "\t" + record.getEnd() + "\t");
        double score = record.getScore();
        if (score == GFFTools.NO_SCORE) {
            this.out.print(".\t");
        } else {
            this.out.print(score + "\t");
        }
        StrandedFeature.Strand strand = record.getStrand();
        if (strand == StrandedFeature.POSITIVE) {
            this.out.print("+\t");
        } else if (strand == StrandedFeature.NEGATIVE) {
            this.out.print("-\t");
        } else {
            this.out.print(".\t");
        }
        int frame = record.getFrame();
        if (frame == GFFTools.NO_FRAME) {
            this.out.print(".");
        } else {
            this.out.print(frame + "");
        }
        Map gaMap = record.getGroupAttributes();
        String ga = SimpleGFFRecord.stringifyAttributes(gaMap);
        if (ga != null && ga.length() > 0) {
            this.out.print("\t" + ga);
        }
        if ((comment = record.getComment()) != null && comment.length() > 0) {
            if (ga != null && ga.length() > 0) {
                this.out.print(" ");
            }
            this.out.print(comment);
        }
        this.out.println("");
    }

    public void invalidStart(String token, NumberFormatException nfe) throws BioException {
    }

    public void invalidEnd(String token, NumberFormatException nfe) throws BioException {
    }

    public void invalidScore(String token, NumberFormatException nfe) throws BioException {
    }

    public void invalidStrand(String token) throws BioException {
    }

    public void invalidFrame(String token, NumberFormatException nfe) throws BioException {
    }
}

