/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import org.biojava.bio.program.homologene.DuplicateTaxonException;
import org.biojava.bio.program.homologene.HomologeneBuilder;
import org.biojava.bio.program.homologene.HomologeneDB;
import org.biojava.bio.program.homologene.HomologeneTools;
import org.biojava.bio.program.homologene.OrthoPair;
import org.biojava.bio.program.homologene.OrthoPairSet;
import org.biojava.bio.program.homologene.Orthologue;
import org.biojava.bio.program.homologene.SimilarityType;
import org.biojava.bio.program.homologene.SimpleHomologeneDB;
import org.biojava.bio.program.homologene.SimpleOrthologue;
import org.biojava.bio.program.homologene.Taxon;
import org.biojava.utils.ChangeVetoException;

public class SimpleHomologeneBuilder
implements HomologeneBuilder {
    HomologeneDB db = null;
    OrthoPairTemplate orthologyTmpl = null;
    OrthologueTemplate orthologueTmpl = null;
    OrthoPairSet group = null;
    private int level = 0;

    @Override
    public void startDB() {
        if (this.level != 0) {
            return;
        }
        this.db = new SimpleHomologeneDB();
        ++this.level;
    }

    @Override
    public void startGroup() {
        if (this.level != 1) {
            return;
        }
        this.group = this.db.createOrthoPairSet();
        ++this.level;
    }

    @Override
    public void startOrthoPair() {
        if (this.level != 2) {
            return;
        }
        this.orthologyTmpl = new OrthoPairTemplate();
        ++this.level;
    }

    @Override
    public void startOrthologue() {
        if (this.level != 3) {
            return;
        }
        this.orthologueTmpl = new OrthologueTemplate();
        ++this.level;
    }

    @Override
    public void addOrthologueProperty(String key, String value) {
        if (this.level != 4) {
            return;
        }
        if (this.orthologueTmpl != null) {
            if (key.equals("TaxonID")) {
                this.orthologueTmpl.taxonID = Integer.parseInt(value);
            } else if (key.equals("LocusID")) {
                this.orthologueTmpl.locusID = value;
            } else if (key.equals("HomologeneID")) {
                this.orthologueTmpl.homologeneID = value;
            } else if (key.equals("Accession")) {
                this.orthologueTmpl.accession = value;
            }
        }
    }

    @Override
    public void endOrthologue() {
        Orthologue orthologue;
        if (this.level != 4) {
            return;
        }
        --this.level;
        if (this.orthologueTmpl.taxonID == -9999 || this.orthologueTmpl.homologeneID == null || this.orthologueTmpl.accession == null) {
            return;
        }
        Taxon taxon = HomologeneTools.getTaxon(this.orthologueTmpl.taxonID);
        if (taxon == null) {
            try {
                taxon = HomologeneTools.createTaxon(this.orthologueTmpl.taxonID, "Unknown species " + this.orthologueTmpl.taxonID);
            }
            catch (DuplicateTaxonException dte) {
                // empty catch block
            }
        }
        if ((orthologue = this.db.getOrthologue(this.orthologueTmpl.homologeneID)) == null) {
            orthologue = new SimpleOrthologue(taxon, this.orthologueTmpl.locusID, this.orthologueTmpl.homologeneID, this.orthologueTmpl.accession);
        }
        if (this.orthologyTmpl.firstOrtho == null) {
            this.orthologyTmpl.firstOrtho = orthologue;
        } else {
            this.orthologyTmpl.secondOrtho = orthologue;
        }
        this.orthologueTmpl = null;
    }

    @Override
    public void addOrthoPairProperty(String key, String value) {
        if (this.level != 3) {
            return;
        }
        if (key.equals("SimilarityType")) {
            String type = value.trim();
            if (type.equals("twin")) {
                this.orthologyTmpl.type = SimilarityType.TWIN;
            } else if (type.equals("multiple")) {
                this.orthologyTmpl.type = SimilarityType.MULTIPLE;
            } else if (type.equals("curated")) {
                this.orthologyTmpl.type = SimilarityType.CURATED;
            }
        } else if (key.equals("PercentIdentity")) {
            this.orthologyTmpl.percentIdentity = Double.parseDouble(value);
        } else if (key.equals("Reference")) {
            this.orthologyTmpl.ref = value;
        }
    }

    @Override
    public void endOrthoPair() {
        if (this.level != 3) {
            return;
        }
        --this.level;
        if (this.orthologyTmpl.type == null || this.orthologyTmpl.firstOrtho == null || this.orthologyTmpl.secondOrtho == null) {
            System.out.println(this.orthologyTmpl.type + " " + this.orthologyTmpl.firstOrtho + " " + this.orthologyTmpl.secondOrtho);
            System.out.println("endOrthoPair test failed");
            return;
        }
        try {
            if (this.orthologyTmpl.type == SimilarityType.CURATED) {
                if (this.orthologyTmpl.ref == null) {
                    return;
                }
                OrthoPair orthology = this.db.createOrthoPair(this.orthologyTmpl.firstOrtho, this.orthologyTmpl.secondOrtho, this.orthologyTmpl.ref);
                this.group.addOrthoPair(orthology);
            } else {
                OrthoPair orthology = this.db.createOrthoPair(this.orthologyTmpl.firstOrtho, this.orthologyTmpl.secondOrtho, this.orthologyTmpl.type, this.orthologyTmpl.percentIdentity);
                this.group.addOrthoPair(orthology);
            }
        }
        catch (ChangeVetoException changeVetoException) {
            // empty catch block
        }
    }

    @Override
    public void addTitle(int taxonID, String homologeneID, String title) {
        Orthologue ortho = this.db.getOrthologue(homologeneID);
        if (ortho != null) {
            ortho.setTitle(title);
        }
    }

    @Override
    public void endGroup() {
        if (this.level != 2) {
            return;
        }
        --this.level;
    }

    @Override
    public void endDB() {
        if (this.level != 1) {
            return;
        }
        --this.level;
    }

    @Override
    public HomologeneDB getDB() {
        return this.db;
    }

    private class OrthologueTemplate {
        int taxonID = -9999;
        String locusID = null;
        String homologeneID = null;
        String accession = null;

        private OrthologueTemplate() {
        }
    }

    private class OrthoPairTemplate {
        Orthologue firstOrtho;
        Orthologue secondOrtho;
        SimilarityType type;
        double percentIdentity;
        String ref;

        private OrthoPairTemplate() {
        }
    }
}

