/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.biojava.bio.program.indexdb.IndexTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.flat.FlatSequenceDB;

public class IndexToolsTest
extends TestCase {
    protected String location;

    public IndexToolsTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException {
        this.location = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "IndexToolsTest." + System.currentTimeMillis() + ".idx";
    }

    public void testIndexFastaDNA() throws Exception {
        File[] files = this.getDBFiles(new String[]{"dna1.fasta", "dna2.fasta"});
        IndexTools.indexFasta("test", new File(this.location), files, 131072);
        FlatSequenceDB db = new FlatSequenceDB(this.location, "dna");
        Sequence seq1 = db.getSequence("id1");
        IndexToolsTest.assertEquals((String)"gatatcgatt", (String)seq1.seqString());
        Sequence seq2 = db.getSequence("id2");
        IndexToolsTest.assertEquals((String)"ggcgcgcgcg", (String)seq2.seqString());
        Sequence seq3 = db.getSequence("id3");
        IndexToolsTest.assertEquals((String)"ccccccccta", (String)seq3.seqString());
        Sequence seq4 = db.getSequence("id4");
        IndexToolsTest.assertEquals((String)"tttttcgatt", (String)seq4.seqString());
        Sequence seq5 = db.getSequence("id5");
        IndexToolsTest.assertEquals((String)"ggttcgcgcg", (String)seq5.seqString());
        Sequence seq6 = db.getSequence("id6");
        IndexToolsTest.assertEquals((String)"nnnnnnttna", (String)seq6.seqString());
    }

    public void testIndexFastaRNA() throws Exception {
        File[] files = this.getDBFiles(new String[]{"rna1.fasta", "rna2.fasta"});
        IndexTools.indexFasta("test", new File(this.location), files, 262144);
        FlatSequenceDB db = new FlatSequenceDB(this.location, "rna");
        Sequence seq1 = db.getSequence("id1");
        IndexToolsTest.assertEquals((String)"gauaucgauu", (String)seq1.seqString());
        Sequence seq2 = db.getSequence("id2");
        IndexToolsTest.assertEquals((String)"ggcgcgcgcg", (String)seq2.seqString());
        Sequence seq3 = db.getSequence("id3");
        IndexToolsTest.assertEquals((String)"uuuuucgauu", (String)seq3.seqString());
        Sequence seq4 = db.getSequence("id4");
        IndexToolsTest.assertEquals((String)"gguucgcgcg", (String)seq4.seqString());
    }

    public void testIndexFastaProtein() throws Exception {
        File[] files = this.getDBFiles(new String[]{"protein1.fasta", "protein2.fasta"});
        IndexTools.indexFasta("test", new File(this.location), files, 524288);
        FlatSequenceDB db = new FlatSequenceDB(this.location, "protein");
        Sequence seq1 = db.getSequence("id1");
        IndexToolsTest.assertEquals((String)"MTTSRGGGGG", (String)seq1.seqString());
        Sequence seq2 = db.getSequence("id2");
        IndexToolsTest.assertEquals((String)"VVLLLLDDTN", (String)seq2.seqString());
        Sequence seq3 = db.getSequence("id3");
        IndexToolsTest.assertEquals((String)"MVVVLNNGGG", (String)seq3.seqString());
        Sequence seq4 = db.getSequence("id4");
        IndexToolsTest.assertEquals((String)"NGGDEEFDTN", (String)seq4.seqString());
    }

    public void testIndexEmblDNA() throws Exception {
        File[] files = this.getDBFiles(new String[]{"part1.embl", "part2.embl"});
        IndexTools.indexEmbl("test", new File(this.location), files, 131072);
        FlatSequenceDB db = new FlatSequenceDB(this.location, "embl");
        Sequence seq1 = db.getSequence("A16SRRNA");
        IndexToolsTest.assertEquals((int)1497, (int)seq1.length());
        Sequence seq2 = db.getSequence("A16STM112");
        IndexToolsTest.assertEquals((int)1346, (int)seq2.length());
        Sequence seq3 = db.getSequence("A16STM146");
        IndexToolsTest.assertEquals((int)1352, (int)seq3.length());
        Sequence seq4 = db.getSequence("AY080928");
        IndexToolsTest.assertEquals((int)557, (int)seq4.length());
        Sequence seq5 = db.getSequence("AY080929");
        IndexToolsTest.assertEquals((int)556, (int)seq5.length());
        Sequence seq6 = db.getSequence("AY080930");
        IndexToolsTest.assertEquals((int)557, (int)seq6.length());
    }

    public void testIndexGenbankDNA() throws Exception {
        File[] files = this.getDBFiles(new String[]{"part1.gb", "part2.gb"});
        IndexTools.indexGenbank("test", new File(this.location), files, 131072);
        FlatSequenceDB db = new FlatSequenceDB(this.location, "genbank");
        Sequence seq1 = db.getSequence("A16SRRNA");
        IndexToolsTest.assertEquals((int)1497, (int)seq1.length());
        Sequence seq2 = db.getSequence("A16STM112");
        IndexToolsTest.assertEquals((int)1346, (int)seq2.length());
        Sequence seq3 = db.getSequence("A16STM146");
        IndexToolsTest.assertEquals((int)1352, (int)seq3.length());
        Sequence seq4 = db.getSequence("AY080928");
        IndexToolsTest.assertEquals((int)557, (int)seq4.length());
        Sequence seq5 = db.getSequence("AY080929");
        IndexToolsTest.assertEquals((int)556, (int)seq5.length());
        Sequence seq6 = db.getSequence("AY080930");
        IndexToolsTest.assertEquals((int)557, (int)seq6.length());
    }

    public void testIndexSwissprot() throws Exception {
        File[] files = this.getDBFiles(new String[]{"part1.swiss", "part2.swiss"});
        IndexTools.indexSwissprot("test", new File(this.location), files);
        FlatSequenceDB db = new FlatSequenceDB(this.location, "swiss");
        Sequence seq1 = db.getSequence("104K_THEPA");
        IndexToolsTest.assertEquals((int)924, (int)seq1.length());
        Sequence seq2 = db.getSequence("108_LYCES");
        IndexToolsTest.assertEquals((int)102, (int)seq2.length());
        Sequence seq3 = db.getSequence("10KD_VIGUN");
        IndexToolsTest.assertEquals((int)75, (int)seq3.length());
        Sequence seq4 = db.getSequence("110K_PLAKN");
        IndexToolsTest.assertEquals((int)296, (int)seq4.length());
        Sequence seq5 = db.getSequence("11S3_HELAN");
        IndexToolsTest.assertEquals((int)493, (int)seq5.length());
        Sequence seq6 = db.getSequence("11SB_CUCMA");
        IndexToolsTest.assertEquals((int)480, (int)seq6.length());
    }

    private File[] getDBFiles(String[] fileNames) throws Exception {
        File[] files = new File[fileNames.length];
        for (int i = 0; i < files.length; ++i) {
            URL seqURL = ((Object)((Object)this)).getClass().getResource(fileNames[i]);
            files[i] = new File(seqURL.getFile());
        }
        return files;
    }
}

