/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class NeedleAlignmentSAXParser
extends AbstractNativeAppSAXParser {
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private String oSeqName;
    private String oTmpSeq;
    private StringBuffer oSeq = new StringBuffer();
    private HashMap oAlignment = new HashMap();
    private ArrayList oSeqNameList = new ArrayList();
    private static final int STARTUP = 0;
    private static final int IN_STREAM = 1;

    public NeedleAlignmentSAXParser() {
        this.iState = 0;
        this.setNamespacePrefix("biojava");
    }

    @Override
    public void parse(InputSource poSource) throws IOException, SAXException {
        String oLine = null;
        BufferedReader oContents = this.getContentStream(poSource);
        try {
            oLine = oContents.readLine();
            while (oLine != null) {
                this.interpret(oContents, oLine);
                oLine = oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("Stream read interupted");
        }
        this.nibbleEndGaps();
        for (int i = 0; i < this.oSeqNameList.size(); ++i) {
            this.oSeqName = (String)this.oSeqNameList.get(i);
            this.emitSequence(this.oSeqName, (String)this.oAlignment.get(this.oSeqName));
        }
        this.endElement(new QName(this, this.prefix("SequenceCollection")));
        oContents.close();
    }

    private void interpret(BufferedReader poContents, String poLine) throws SAXException {
        if (this.iState == 0) {
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("SequenceCollection")), this.oAtts);
            this.changeState(1);
        }
        if (this.iState == 1 && this.lineIsRelevant(poLine)) {
            this.appendToAlignment(poLine);
        }
    }

    private void appendToAlignment(String poLine) {
        StringTokenizer oSt = new StringTokenizer(poLine, "\n\t\r ");
        this.oSeqName = oSt.nextToken();
        this.oSeq.setLength(0);
        this.oTmpSeq = poLine.substring(25, 70).replace('.', '-').replace(' ', '-');
        this.oSeq.append(this.oTmpSeq);
        if (this.oAlignment.get(this.oSeqName) == null) {
            this.oAlignment.put(this.oSeqName, this.oSeq.substring(0));
            this.oSeqNameList.add(this.oSeqName);
        } else {
            this.oTmpSeq = (String)this.oAlignment.get(this.oSeqName);
            this.oAlignment.put(this.oSeqName, this.oTmpSeq.concat(this.oSeq.substring(0)));
        }
    }

    private boolean lineIsRelevant(String poLine) {
        return !poLine.trim().equals("") && !poLine.startsWith(" ") && !poLine.startsWith("Global: ") && !poLine.startsWith("Score: ") && !poLine.startsWith("%id = ") && !poLine.startsWith("Overall %id = ");
    }

    private void emitSequence(String poSequenceName, String poSequence) throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("sequenceName");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", poSequenceName);
        this.startElement(new QName(this, this.prefix("Sequence")), this.oAtts);
        this.aoChars = poSequence.toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("Sequence")));
    }

    private void nibbleEndGaps() {
        String oSeqName1 = (String)this.oSeqNameList.get(0);
        String oSeqName2 = (String)this.oSeqNameList.get(1);
        String oSeq1 = (String)this.oAlignment.get(oSeqName1);
        String oSeq2 = (String)this.oAlignment.get(oSeqName2);
        int iLength = oSeq1.length();
        int iNibbles = 0;
        boolean tNibble = true;
        int iPos = iLength - 1;
        while (tNibble) {
            if (oSeq1.charAt(iPos) == '-' && oSeq2.charAt(iPos) == '-') {
                ++iNibbles;
                --iPos;
                continue;
            }
            tNibble = false;
        }
        if (iNibbles > 0) {
            this.oAlignment.put(oSeqName1, oSeq1.substring(0, iLength - iNibbles));
            this.oAlignment.put(oSeqName2, oSeq2.substring(0, iLength - iNibbles));
        }
    }
}

