/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PdbSAXParser
extends AbstractNativeAppSAXParser {
    private ArrayList oRecordList = new ArrayList();
    private String oRecord;
    private int iPos;
    private int iModelStart;
    private int iModelStop;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);

    public PdbSAXParser() {
        this.setNamespacePrefix("biojava");
    }

    @Override
    public void parse(String poURI) throws IOException, SAXException {
        this.parse(new InputSource(poURI));
    }

    @Override
    public void parse(InputSource poSource) throws IOException, SAXException {
        String oLine = null;
        BufferedReader oContents = this.getContentStream(poSource);
        try {
            oLine = oContents.readLine();
            while (oLine != null) {
                String oPadLine = this.padLine(oLine);
                this.oRecordList.add(oPadLine);
                oLine = oContents.readLine();
            }
            boolean tIsModel = false;
            for (int i = 0; i < this.oRecordList.size(); ++i) {
                this.oRecord = (String)this.oRecordList.get(i);
                if (!this.oRecord.startsWith("MODEL")) continue;
                tIsModel = true;
                break;
            }
            boolean tFoundFirstAtom = false;
            if (!tIsModel) {
                for (int i = 0; i < this.oRecordList.size(); ++i) {
                    this.oRecord = (String)this.oRecordList.get(i);
                    if (!this.oRecord.startsWith("ATOM  ") && !this.oRecord.startsWith("HETATM") || tFoundFirstAtom) continue;
                    tFoundFirstAtom = true;
                    this.oRecordList.add(i, "MODEL        1");
                    break;
                }
                boolean tFoundLastAtom = false;
                for (int i = this.oRecordList.size() - 1; i > 0; --i) {
                    this.oRecord = (String)this.oRecordList.get(i);
                    if (!this.oRecord.startsWith("ATOM  ") && !this.oRecord.startsWith("HETATM") && !this.oRecord.startsWith("TER") || tFoundLastAtom) continue;
                    tFoundLastAtom = true;
                    this.oRecordList.add(i + 1, "ENDMDL");
                    break;
                }
            }
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("MolecularStructureList")), this.oAtts);
            this.iPos = 0;
            this.iModelStart = 0;
            this.iModelStop = 0;
            while (this.iPos < this.oRecordList.size()) {
                this.oRecord = (String)this.oRecordList.get(this.iPos);
                if (this.oRecord.startsWith("HEADER")) {
                    String oStructureId = this.oRecord.substring(62, 66).trim();
                    System.out.println(oStructureId);
                    this.oAtts.clear();
                    this.oAttQName.setQName("id");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oStructureId);
                    this.startElement(new QName(this, this.prefix("PdbCode")), this.oAtts);
                    this.endElement(new QName(this, this.prefix("PdbCode")));
                }
                if (this.oRecord.startsWith("MODEL")) {
                    this.iModelStart = this.iPos;
                    String oModelId = this.oRecord.substring(10, 14).trim();
                    this.oAtts.clear();
                    this.oAttQName.setQName("modelId");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oModelId);
                    this.startElement(new QName(this, this.prefix("MolecularStructure")), this.oAtts);
                }
                if (this.oRecord.startsWith("ENDMDL")) {
                    this.iModelStop = this.iPos;
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("Protein")), this.oAtts);
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("ProteinChainList")), this.oAtts);
                    this.parseProtein(this.iModelStart, this.iModelStop);
                    this.endElement(new QName(this, this.prefix("Atom")));
                    this.endElement(new QName(this, this.prefix("AminoAcidResidue")));
                    this.endElement(new QName(this, this.prefix("ProteinChain")));
                    this.endElement(new QName(this, this.prefix("ProteinChainList")));
                    this.endElement(new QName(this, this.prefix("MolecularStructure")));
                }
                ++this.iPos;
            }
            this.endElement(new QName(this, this.prefix("MolecularStructureList")));
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interupted");
        }
    }

    private void parseProtein(int piStart, int piStop) throws SAXException {
        boolean tFirstChain = true;
        boolean tFirstResidue = true;
        String oCurrentChainId = "XXX";
        String oCurrentResidueId = "A*ZZ**";
        for (int i = piStart; i < piStop; ++i) {
            this.oRecord = (String)this.oRecordList.get(i);
            if (!this.oRecord.startsWith("ATOM  ") && !this.oRecord.startsWith("HETATM")) continue;
            String oAtomId = this.oRecord.substring(6, 11).trim();
            String oAtomType = this.oRecord.substring(12, 16).trim();
            String oResidueType = this.oRecord.substring(17, 20).trim();
            if (!this.checkIfProtein(oResidueType)) continue;
            String oChainId = this.oRecord.substring(21, 23).trim();
            String oResidueId = this.oRecord.substring(23, 27).trim();
            String oX = this.oRecord.substring(30, 38).trim();
            String oY = this.oRecord.substring(38, 46).trim();
            String oZ = this.oRecord.substring(46, 54).trim();
            String oOccupancy = this.oRecord.substring(54, 60).trim();
            String oTemperatureFactor = this.oRecord.substring(60, 66).trim();
            String oElement = this.oRecord.substring(76, 78).trim();
            if (!oResidueId.equals(oCurrentResidueId)) {
                if (!tFirstResidue) {
                    this.endElement(new QName(this, this.prefix("AminoAcidResidue")));
                }
                if (!oChainId.equals(oCurrentChainId)) {
                    if (!tFirstChain) {
                        this.endElement(new QName(this, this.prefix("ProteinChain")));
                    }
                    this.oAtts.clear();
                    this.oAttQName.setQName("chainId");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oChainId);
                    this.startElement(new QName(this, this.prefix("ProteinChain")), this.oAtts);
                    tFirstChain = false;
                    oCurrentChainId = oChainId;
                }
                this.oAtts.clear();
                this.oAttQName.setQName("residueId");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oResidueId);
                this.oAttQName.setQName("residueType");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oResidueType);
                this.startElement(new QName(this, this.prefix("AminoAcidResidue")), this.oAtts);
                tFirstResidue = false;
                oCurrentResidueId = oResidueId;
            }
            this.oAtts.clear();
            this.oAttQName.setQName("atomId");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oAtomId);
            this.oAttQName.setQName("atomType");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oAtomType);
            if (!oElement.equals("")) {
                this.oAttQName.setQName("element");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oElement);
            }
            this.oAttQName.setQName("occupancy");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oOccupancy);
            this.oAttQName.setQName("temperatureFactor");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oTemperatureFactor);
            this.startElement(new QName(this, this.prefix("Atom")), this.oAtts);
            this.oAtts.clear();
            this.oAttQName.setQName("x");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oX);
            this.oAttQName.setQName("y");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oY);
            this.oAttQName.setQName("z");
            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oZ);
            this.startElement(new QName(this, this.prefix("Coordinates")), this.oAtts);
            this.endElement(new QName(this, this.prefix("Coordinates")));
            this.endElement(new QName(this, this.prefix("Atom")));
        }
    }

    private boolean checkIfProtein(String poResType) {
        return true;
    }

    private String padLine(String poLine) {
        int iLength = poLine.length();
        int iDesiredLength = 80;
        int cPadChar = 32;
        if (iLength >= 80) {
            return poLine;
        }
        StringBuffer oBuff = new StringBuffer(poLine);
        int iInsertLength = iDesiredLength - iLength;
        char[] aoInsert = new char[iInsertLength];
        for (int i = 0; i < iInsertLength; ++i) {
            aoInsert[i] = cPadChar;
        }
        oBuff.append(aoInsert);
        return oBuff.substring(0);
    }
}

