/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax.blastxml;

import org.biojava.bio.program.sax.blastxml.BlastOutputIterationsHandler;
import org.biojava.bio.program.sax.blastxml.StAXFeatureHandler;
import org.biojava.bio.program.sax.blastxml.StAXHandlerFactory;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class BlastOutputHandler
extends StAXFeatureHandler {
    public static final StAXHandlerFactory BLASTOUTPUT_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new BlastOutputHandler(staxenv);
        }
    };
    private String program = null;
    private String version = null;
    private String databaseId = null;
    private String queryId = null;
    private String queryDef = null;
    boolean wrap = true;

    public BlastOutputHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.initDelegation();
    }

    private void initDelegation() {
        super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput_program"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    @Override
                    public void setStringValue(String s) throws SAXException {
                        BlastOutputHandler.this.program = s.trim();
                        if (BlastOutputHandler.this.program.equals("blastn")) {
                            StAXFeatureHandler.querySequenceType = "dna";
                            StAXFeatureHandler.hitSequenceType = "dna";
                        } else if (BlastOutputHandler.this.program.equals("blastp")) {
                            StAXFeatureHandler.querySequenceType = "protein";
                            StAXFeatureHandler.hitSequenceType = "protein";
                        } else if (BlastOutputHandler.this.program.equals("blastx")) {
                            StAXFeatureHandler.querySequenceType = "protein";
                            StAXFeatureHandler.hitSequenceType = "protein";
                        } else if (BlastOutputHandler.this.program.equals("tblastn")) {
                            StAXFeatureHandler.querySequenceType = "protein";
                            StAXFeatureHandler.hitSequenceType = "protein";
                        } else if (BlastOutputHandler.this.program.equals("tblastx")) {
                            StAXFeatureHandler.querySequenceType = "protein";
                            StAXFeatureHandler.hitSequenceType = "protein";
                        } else {
                            throw new SAXException("unknown BLAST program.");
                        }
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput_version"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    @Override
                    public void setStringValue(String s) throws SAXException {
                        BlastOutputHandler.this.version = s.trim();
                    }

                    @Override
                    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                        super.startElement(nsURI, localName, qName, attrs, dm);
                    }

                    @Override
                    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
                        ContentHandler listener = BlastOutputHandler.this.getListener();
                        super.endElement(nsURI, localName, qName, handler);
                        AttributesImpl bldsAttrs = new AttributesImpl();
                        if (BlastOutputHandler.this.program != null && BlastOutputHandler.this.version != null) {
                            bldsAttrs.addAttribute("http://www.biojava.org", "program", "program", "CDATA", BlastOutputHandler.this.program);
                            bldsAttrs.addAttribute("http://www.biojava.org", "version", "version", "CDATA", BlastOutputHandler.this.version);
                        }
                        listener.startElement("http://www.biojava.org", "BlastLikeDataSet", "http://www.biojava.org:BlastLikeDataSet", bldsAttrs);
                        listener.startElement("http://www.biojava.org", "Header", "http://www.biojava.org:Header", new AttributesImpl());
                        listener.startElement("http://www.biojava.org", "RawOutput", "http://www.biojava.org:RawOutput", new AttributesImpl());
                        listener.endElement("http://www.biojava.org", "RawOutput", "http://www.biojava.org:RawOutput");
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput_db"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    @Override
                    public void setStringValue(String s) throws SAXException {
                        BlastOutputHandler.this.databaseId = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput_query-ID"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    @Override
                    public void setStringValue(String s) throws SAXException {
                        BlastOutputHandler.this.queryId = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput_query-def"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    @Override
                    public void setStringValue(String s) throws SAXException {
                        BlastOutputHandler.this.queryDef = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("BlastOutput_iterations"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new BlastOutputIterationsHandler(staxenv){

                    @Override
                    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
                        ContentHandler listener = this.getListener();
                        if (BlastOutputHandler.this.queryId != null) {
                            AttributesImpl queryAttrs = new AttributesImpl();
                            queryAttrs.addAttribute("http://www.biojava.org", "id", "id", "CDATA", BlastOutputHandler.this.queryId);
                            queryAttrs.addAttribute("http://www.biojava.org", "metadata", "metadata", "CDATA", "none");
                            listener.startElement("http://www.biojava.org", "QueryId", "http://www.biojava.org:QueryId", queryAttrs);
                            listener.endElement("http://www.biojava.org", "QueryId", "http://www.biojava.org:QueryId");
                        }
                        if (BlastOutputHandler.this.queryDef != null) {
                            listener.startElement("http://www.biojava.org", "QueryDescription", "http://www.biojava.org:QueryDescription", new AttributesImpl());
                            listener.characters(BlastOutputHandler.this.queryDef.toCharArray(), 0, BlastOutputHandler.this.queryDef.length());
                            listener.endElement("http://www.biojava.org", "QueryDescription", "http://www.biojava.org:QueryDescription");
                        }
                        if (BlastOutputHandler.this.databaseId != null) {
                            AttributesImpl dbAttrs = new AttributesImpl();
                            dbAttrs.addAttribute("http://www.biojava.org", "id", "id", "CDATA", BlastOutputHandler.this.databaseId);
                            dbAttrs.addAttribute("http://www.biojava.org", "metadata", "metadata", "CDATA", "none");
                            listener.startElement("http://www.biojava.org", "DatabaseId", "http://www.biojava.org:DatabaseId", dbAttrs);
                            listener.endElement("http://www.biojava.org", "DatabaseId", "http://www.biojava.org:DatabaseId");
                        }
                        listener.endElement("http://www.biojava.org", "Header", "http://www.biojava.org:Header");
                        super.startElementHandler(nsURI, localName, qName, attrs);
                    }
                };
            }
        });
    }

    @Override
    void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        this.staxenv.listener.endElement("http://www.biojava.org", "BlastLikeDataSet", "http://www.biojava.org:BlastLikeDataSet");
    }
}

