/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax.blastxml;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.BioException;
import org.biojava.bio.program.sax.blastxml.BlastXMLParser;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BlastXMLParserFacade
implements XMLReader {
    private ContentHandler contentHandler;
    final BlastXMLParser blasthandler = new BlastXMLParser();
    XMLReader parser;
    private String baseURI;

    public BlastXMLParserFacade() throws BioException {
        DefaultHandler handler = new DefaultHandler();
        this.contentHandler = handler;
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this.parser.setEntityResolver(new Resolver());
            this.parser.setContentHandler(new SAX2StAXAdaptor(this.blasthandler));
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.baseURI = this.getClass().getClassLoader().getResource("org/biojava/bio/program/sax/blastxml/").toString();
        }
        catch (SAXException se) {
            throw new BioException(se);
        }
        catch (ParserConfigurationException sce) {
            throw new BioException(sce);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.parser.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getProperty(name);
    }

    @Override
    public void parse(InputSource is) throws IOException, SAXException {
        if (is.getSystemId() == null) {
            is.setSystemId(this.baseURI);
        }
        this.parser.parse(is);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parser.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        this.blasthandler.setContentHandler(handler);
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.parser.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.parser.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String key, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature(key, value);
    }

    @Override
    public void setProperty(String key, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setProperty(key, value);
    }

    private class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
            String resourceName = "org/biojava/bio/program/sax/blastxml/";
            if (publicID.equals("-//NCBI//NCBI BlastOutput/EN")) {
                resourceName = resourceName + "NCBI_BlastOutput.dtd";
            } else if (publicID.equals("-//NCBI//NCBI Entity Module//EN")) {
                resourceName = resourceName + "NCBI_Entity.mod";
            } else if (publicID.equals("-//NCBI//NCBI BlastOutput Module//EN")) {
                resourceName = resourceName + "NCBI_BlastOutput.mod";
            } else {
                return null;
            }
            InputSource is = new InputSource(this.getClass().getClassLoader().getResourceAsStream(resourceName));
            is.setSystemId(BlastXMLParserFacade.this.baseURI);
            return is;
        }
    }
}

