/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax.blastxml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.program.sax.blastxml.BlastXMLParserFacade;
import org.biojava.bio.program.ssbind.BlastLikeSearchBuilder;
import org.biojava.bio.program.ssbind.SeqSimilarityAdapter;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.DummySequenceDB;
import org.biojava.bio.seq.db.DummySequenceDBInstallation;
import org.xml.sax.InputSource;

public class BlastXMLTest
extends TestCase {
    private List results;
    private static int EXPECTED_QUERY_COUNT = 1;
    private static int EXPECTED_HIT_COUNT = 5;

    protected void setUp() throws Exception {
        String resName = "org/biojava/bio/program/sax/blastxml/input.xml";
        InputStream resStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resName);
        assert (resStream != null) : "Resource " + resName + " could not be located";
        InputSource is = new InputSource(resStream);
        BlastXMLParserFacade parser = new BlastXMLParserFacade();
        SeqSimilarityAdapter adapter = new SeqSimilarityAdapter();
        parser.setContentHandler(adapter);
        this.results = new ArrayList();
        BlastLikeSearchBuilder builder = new BlastLikeSearchBuilder(this.results, new DummySequenceDB("queries"), new DummySequenceDBInstallation());
        adapter.setSearchContentHandler(builder);
        parser.parse(is);
    }

    public void testHitCount() {
        BlastXMLTest.assertEquals((int)EXPECTED_QUERY_COUNT, (int)this.results.size());
        SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)this.results.get(0);
        BlastXMLTest.assertEquals((int)EXPECTED_HIT_COUNT, (int)result.getHits().size());
    }
}

