/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.program.ssbind.BlastLikeSearchBuilder;
import org.biojava.bio.program.ssbind.SeqSimilarityAdapter;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.DummySequenceDB;
import org.biojava.bio.seq.db.DummySequenceDBInstallation;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;

public class SSBindCase
extends TestCase {
    protected SequenceDB queryDB;
    protected SequenceDBInstallation dbInstallation;
    protected SeqSimilarityAdapter adapter;
    protected InputStream searchStream;
    protected List searchResults;
    protected double topHitScore;
    protected String topHitSeqID;
    protected int topHitQStart;
    protected int topHitQEnd;
    protected StrandedFeature.Strand topHitQStrand;
    protected int topHitSStart;
    protected int topHitSEnd;
    protected StrandedFeature.Strand topHitSStrand;
    protected double botHitScore;
    protected String botHitSeqID;
    protected int botHitQStart;
    protected int botHitQEnd;
    protected StrandedFeature.Strand botHitQStrand;
    protected int botHitSStart;
    protected int botHitSEnd;
    protected StrandedFeature.Strand botHitSStrand;

    public SSBindCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        this.queryDB = new DummySequenceDB("query");
        this.dbInstallation = new DummySequenceDBInstallation();
        this.searchResults = new ArrayList();
        BlastLikeSearchBuilder builder = new BlastLikeSearchBuilder(this.searchResults);
        builder.setQuerySeqHolder(this.queryDB);
        builder.setSubjectDBInstallation(this.dbInstallation);
        this.adapter = new SeqSimilarityAdapter();
        this.adapter.setSearchContentHandler(builder);
    }

    protected void tearDown() throws Exception {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        this.searchStream.close();
        this.searchStream = null;
        this.queryDB = null;
        this.dbInstallation = null;
        this.adapter = null;
        this.searchResults = null;
        this.topHitSeqID = null;
        this.botHitSeqID = null;
    }

    public void testResultCount() {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        SSBindCase.assertEquals((int)1, (int)this.searchResults.size());
    }

    public void testResultGetQuerySequence() throws Exception {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)this.searchResults.get(0);
        SSBindCase.assertEquals((Object)this.queryDB.getSequence(""), (Object)result.getQuerySequence());
    }

    public void testResultGetSequenceDB() {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)this.searchResults.get(0);
        SSBindCase.assertEquals((Object)this.dbInstallation.getSequenceDB(""), (Object)result.getSequenceDB());
    }

    public void testResultGetAnnotation() {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)this.searchResults.get(0);
        int nrAnnotations = result.getAnnotation().keys().size();
        SSBindCase.assertTrue((nrAnnotations > 3 ? 1 : 0) != 0);
        SSBindCase.assertTrue((nrAnnotations < 6 ? 1 : 0) != 0);
    }

    public void testTopHit() {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)this.searchResults.get(0);
        SeqSimilaritySearchHit hit = (SeqSimilaritySearchHit)result.getHits().get(0);
        SSBindCase.assertEquals((double)this.topHitScore, (double)hit.getScore(), (double)0.0);
        SSBindCase.assertEquals((String)this.topHitSeqID, (String)hit.getSubjectID());
        SSBindCase.assertEquals((int)this.topHitQStart, (int)hit.getQueryStart());
        SSBindCase.assertEquals((int)this.topHitQEnd, (int)hit.getQueryEnd());
        SSBindCase.assertSame((Object)this.topHitQStrand, (Object)hit.getQueryStrand());
        SSBindCase.assertEquals((int)this.topHitSStart, (int)hit.getSubjectStart());
        SSBindCase.assertEquals((int)this.topHitSEnd, (int)hit.getSubjectEnd());
        SSBindCase.assertSame((Object)this.topHitSStrand, (Object)hit.getSubjectStrand());
    }

    public void testBotHit() {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        SeqSimilaritySearchResult result = (SeqSimilaritySearchResult)this.searchResults.get(0);
        List hits = result.getHits();
        SeqSimilaritySearchHit hit = (SeqSimilaritySearchHit)hits.get(hits.size() - 1);
        SSBindCase.assertEquals((double)this.botHitScore, (double)hit.getScore(), (double)0.0);
        SSBindCase.assertEquals((String)this.botHitSeqID, (String)hit.getSubjectID());
        SSBindCase.assertEquals((int)this.botHitQStart, (int)hit.getQueryStart());
        SSBindCase.assertEquals((int)this.botHitQEnd, (int)hit.getQueryEnd());
        SSBindCase.assertSame((Object)this.botHitQStrand, (Object)hit.getQueryStrand());
        SSBindCase.assertEquals((int)this.botHitSStart, (int)hit.getSubjectStart());
        SSBindCase.assertEquals((int)this.botHitSEnd, (int)hit.getSubjectEnd());
        SSBindCase.assertSame((Object)this.botHitSStrand, (Object)hit.getSubjectStrand());
    }

    protected void setTopHitValues(double score, String id, int qStart, int qEnd, StrandedFeature.Strand qStrand, int sStart, int sEnd, StrandedFeature.Strand sStrand) {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        this.topHitScore = score;
        this.topHitSeqID = id;
        this.topHitQStart = qStart;
        this.topHitQEnd = qEnd;
        this.topHitQStrand = qStrand;
        this.topHitSStart = sStart;
        this.topHitSEnd = sEnd;
        this.topHitSStrand = sStrand;
    }

    protected void setBotHitValues(double score, String id, int qStart, int qEnd, StrandedFeature.Strand qStrand, int sStart, int sEnd, StrandedFeature.Strand sStrand) {
        if (((Object)((Object)this)).getClass().getName().equals("org.biojava.bio.program.ssbind.SSBindCase")) {
            return;
        }
        this.botHitScore = score;
        this.botHitSeqID = id;
        this.botHitQStart = qStart;
        this.botHitQEnd = qEnd;
        this.botHitQStrand = qStrand;
        this.botHitSStart = sStart;
        this.botHitSEnd = sEnd;
        this.botHitSStrand = sStrand;
    }
}

