/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;

public class Echo
implements TagValueListener {
    private int depth = 0;
    private String indent = "";

    @Override
    public void startRecord() {
        System.out.println(this.depth + this.indent + "[");
        this.indent();
    }

    @Override
    public void endRecord() {
        this.outdent();
        System.out.println(this.depth + this.indent + "]");
    }

    @Override
    public void startTag(Object tag) {
        System.out.println(this.depth + this.indent + tag + " {");
        this.indent();
    }

    @Override
    public void endTag() {
        this.outdent();
        System.out.println(this.depth + this.indent + "}");
    }

    private void indent() {
        ++this.depth;
        this.indent = this.indent + "  ";
    }

    private void outdent() {
        this.indent = "";
        --this.depth;
        for (int i = 0; i < this.depth; ++i) {
            this.indent = this.indent + "  ";
        }
    }

    @Override
    public void value(TagValueContext tvc, Object value) {
        System.out.println(this.depth + this.indent + value);
    }
}

