/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import junit.framework.TestCase;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.IsoelectricPointCalc;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class IsoelectricPointCalcTest
extends TestCase {
    public void testPKTables() {
        SymbolPropertyTable PK_NtermTable = ProteinTools.getSymbolPropertyTable("pK_Nterm");
        SymbolPropertyTable pKTable = ProteinTools.getSymbolPropertyTable("pK");
        SymbolPropertyTable PK_CtermTable = ProteinTools.getSymbolPropertyTable("pK_Cterm");
        try {
            double pK = PK_NtermTable.getDoubleValue(ProteinTools.d());
            IsoelectricPointCalcTest.assertTrue((pK == 7.5 ? 1 : 0) != 0);
            pK = pKTable.getDoubleValue(ProteinTools.d());
            IsoelectricPointCalcTest.assertTrue((pK == -4.05 ? 1 : 0) != 0);
            pK = PK_CtermTable.getDoubleValue(ProteinTools.d());
            IsoelectricPointCalcTest.assertTrue((pK == -4.55 ? 1 : 0) != 0);
        }
        catch (IllegalSymbolException ex) {
            IsoelectricPointCalcTest.fail((String)ex.getMessage());
        }
    }

    public void testGetIsoelectricPointTest() {
        try {
            SymbolList pro = ProteinTools.createProtein("hhhhhher");
            double p1 = IsoelectricPointCalc.getIsoelectricPoint(pro);
            pro = ProteinTools.createProtein("h-hhhhher");
            double p2 = IsoelectricPointCalc.getIsoelectricPoint(pro);
            pro = ProteinTools.createProtein("hxhhhhher");
            double p3 = IsoelectricPointCalc.getIsoelectricPoint(pro);
            IsoelectricPointCalcTest.assertTrue((p1 == p2 ? 1 : 0) != 0);
            IsoelectricPointCalcTest.assertTrue((p1 == p3 ? 1 : 0) != 0);
            pro = ProteinTools.createProtein("cdehkry");
            double p4 = IsoelectricPointCalc.getIsoelectricPoint(pro);
            IsoelectricPointCalcTest.assertTrue((p4 == 6.74 ? 1 : 0) != 0);
            pro = ProteinTools.createProtein("da");
            p4 = IsoelectricPointCalc.getIsoelectricPoint(pro);
            IsoelectricPointCalcTest.assertTrue((p4 == 3.8 ? 1 : 0) != 0);
            pro = ProteinTools.createProtein("ad");
            p4 = IsoelectricPointCalc.getIsoelectricPoint(pro);
            IsoelectricPointCalcTest.assertTrue((p4 == 4.3 ? 1 : 0) != 0);
        }
        catch (IllegalSymbolException ex) {
            IsoelectricPointCalcTest.fail((String)ex.getMessage());
        }
        catch (BioException ex) {
            IsoelectricPointCalcTest.fail((String)ex.getMessage());
        }
    }
}

