/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import junit.framework.TestCase;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.MassCalc;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class MassCalcTest
extends TestCase {
    private final double delta = 1.0E-9;
    protected FiniteAlphabet protAlpha;
    protected double monoH = 1.007825;
    protected double avgH = 1.00794;
    protected double monoO = 15.9949146;
    protected double avgO = 15.9994;
    protected double monoAla = 71.037114;
    protected double avgAla = 71.0788;
    protected SymbolList syms1;

    protected void setUp() throws BioException {
        this.protAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
        SymbolTokenization protToke = this.protAlpha.getTokenization("token");
        this.syms1 = new SimpleSymbolList(protToke, "A");
    }

    public MassCalcTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        try {
            MassCalcTest mct = new MassCalcTest("test");
            mct.setUp();
            mct.testGetMass();
        }
        catch (BioException be) {
            be.printStackTrace();
        }
    }

    public void testStaticgetMolecularWeight() {
        try {
            SymbolList pro = ProteinTools.createProtein("arndceqghilkmfpstwyv");
            double m1 = MassCalc.getMolecularWeight(pro);
            double m2 = MassCalc.getMass(pro, "avgMass", false);
            MassCalcTest.assertTrue((m1 == m2 ? 1 : 0) != 0);
            SymbolList proX = ProteinTools.createProtein("xxxxxxxxxxxxxxxxxxxx");
            double m3 = MassCalc.getMolecularWeight(proX);
            MassCalcTest.assertTrue((Math.abs(m3 - m1) < 1.0E-12 ? 1 : 0) != 0);
            SymbolList proX2 = ProteinTools.createProtein("xxxxxx-xxxxxxxxxxxxxx");
            double m4 = MassCalc.getMolecularWeight(proX2);
            MassCalcTest.assertTrue((Math.abs(m4 - m1) < 1.0E-12 ? 1 : 0) != 0);
        }
        catch (IllegalSymbolException ex) {
            MassCalcTest.fail((String)ex.getMessage());
        }
    }

    public void testStaticGetMass() throws IllegalSymbolException {
        double mass = 0.0;
        mass = MassCalc.getMass(this.syms1, "monoMass", false);
        MassCalcTest.assertEquals((double)(this.monoAla + (this.monoO + this.monoH) + this.monoH), (double)mass, (double)1.0E-9);
        mass = MassCalc.getMass(this.syms1, "monoMass", true);
        MassCalcTest.assertEquals((double)(this.monoAla + (this.monoO + this.monoH) + this.monoH + this.monoH), (double)mass, (double)1.0E-9);
        mass = MassCalc.getMass(this.syms1, "avgMass", false);
        MassCalcTest.assertEquals((double)(this.avgAla + (this.avgO + this.avgH) + this.avgH), (double)mass, (double)1.0E-9);
        mass = MassCalc.getMass(this.syms1, "avgMass", true);
        MassCalcTest.assertEquals((double)(this.avgAla + (this.avgO + this.avgH) + this.avgH + this.avgH), (double)mass, (double)1.0E-9);
    }

    public void testGetMass() throws IllegalSymbolException {
        MassCalc mCalc = new MassCalc("monoMass", false);
        MassCalcTest.assertEquals((double)(this.monoAla + (this.monoO + this.monoH) + this.monoH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
        mCalc = new MassCalc("monoMass", true);
        MassCalcTest.assertEquals((double)(this.monoAla + (this.monoO + this.monoH) + this.monoH + this.monoH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
        mCalc = new MassCalc("avgMass", false);
        MassCalcTest.assertEquals((double)(this.avgAla + (this.avgO + this.avgH) + this.avgH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
        mCalc = new MassCalc("avgMass", true);
        MassCalcTest.assertEquals((double)(this.avgAla + (this.avgO + this.avgH) + this.avgH + this.avgH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
    }

    public void testGetTermMass() throws IllegalSymbolException {
        MassCalc mCalc = new MassCalc("monoMass", false);
        MassCalcTest.assertEquals((double)(this.monoO + this.monoH + this.monoH), (double)mCalc.getTermMass(), (double)1.0E-9);
        mCalc = new MassCalc("monoMass", true);
        MassCalcTest.assertEquals((double)(this.monoO + this.monoH + this.monoH + this.monoH), (double)mCalc.getTermMass(), (double)1.0E-9);
        mCalc = new MassCalc("avgMass", false);
        MassCalcTest.assertEquals((double)(this.avgO + this.avgH + this.avgH), (double)mCalc.getTermMass(), (double)1.0E-9);
        mCalc = new MassCalc("avgMass", true);
        MassCalcTest.assertEquals((double)(this.avgO + this.avgH + this.avgH + this.avgH), (double)mCalc.getTermMass(), (double)1.0E-9);
    }

    public void testSetSymbolModification() throws IllegalSymbolException {
        double newAla = 1.0;
        MassCalc mCalc = new MassCalc("monoMass", false);
        mCalc.setSymbolModification('A', newAla);
        MassCalcTest.assertEquals((double)(newAla + (this.monoO + this.monoH) + this.monoH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
        mCalc = new MassCalc("monoMass", true);
        mCalc.setSymbolModification('A', newAla);
        MassCalcTest.assertEquals((double)(newAla + (this.monoO + this.monoH) + this.monoH + this.monoH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
        mCalc = new MassCalc("avgMass", false);
        mCalc.setSymbolModification('A', newAla);
        MassCalcTest.assertEquals((double)(newAla + (this.avgO + this.avgH) + this.avgH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
        mCalc = new MassCalc("avgMass", true);
        mCalc.setSymbolModification('A', newAla);
        MassCalcTest.assertEquals((double)(newAla + (this.avgO + this.avgH) + this.avgH + this.avgH), (double)mCalc.getMass(this.syms1), (double)1.0E-9);
    }

    public void testAlphabetTolerance() {
        try {
            SymbolList syms = ProteinTools.createProtein("achtyilqw");
            MassCalc mCalc = new MassCalc("monoMass", false);
            mCalc.getMass(syms);
        }
        catch (IllegalSymbolException ex) {
            MassCalcTest.fail((String)ex.getMessage());
        }
    }
}

