/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics.aaindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.aaindex.AAindex;
import org.biojava.bio.proteomics.aaindex.AAindexStreamReader;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.SymbolList;

public class AAindexStreamReaderTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(AAindexStreamReaderTest.class);
    }

    public void testReading() throws IOException, BioException {
        InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/biojava/bio/proteomics/aaindex/aaindex1");
        AAindexStreamReader reader = new AAindexStreamReader(new InputStreamReader(input));
        while (reader.hasNext()) {
            AAindex aaindex = (AAindex)reader.nextTable();
            SymbolList symbols = ProteinTools.createProtein("ARNDCEQGHILKMFPSTWYV");
            for (int i = 1; i <= symbols.length(); ++i) {
                aaindex.getDoubleValue(symbols.symbolAt(i));
            }
            AAindexStreamReaderTest.assertNotNull((Object)aaindex.accessionNumber());
            AAindexStreamReaderTest.assertEquals((Object)ProteinTools.getAlphabet(), (Object)aaindex.getAlphabet());
            AAindexStreamReaderTest.assertNotNull((Object)aaindex.getArticleAuthors());
            AAindexStreamReaderTest.assertNotNull((Object)aaindex.getArticleTitle());
            AAindexStreamReaderTest.assertNotNull((Object)aaindex.getDescription());
            AAindexStreamReaderTest.assertNotNull((Object)aaindex.getJournalReference());
            AAindexStreamReaderTest.assertTrue((aaindex.getLITDBEntryNumbers().length > 0 ? 1 : 0) != 0);
            AAindexStreamReaderTest.assertNotNull((Object)aaindex.getName());
            Map entries = aaindex.similarEntries();
            for (String key : entries.keySet()) {
                AAindexStreamReaderTest.assertTrue((boolean)Double.class.isInstance(entries.get(key)));
            }
        }
        AAindexStreamReaderTest.assertTrue((boolean)reader.eof());
    }
}

