/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics.aaindex;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.proteomics.aaindex.AAindex;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;

public class AAindexTest
extends TestCase {
    private AAindex aaindex = null;

    public static void main(String[] args) {
        TestRunner.run(AAindexTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.aaindex = new AAindex("test");
    }

    public void testAccessionNumber() {
        AAindexTest.assertEquals((String)"test", (String)this.aaindex.accessionNumber());
    }

    public void testGetArticleAuthors() {
        AAindexTest.assertNull((Object)this.aaindex.getArticleAuthors());
    }

    public void testSetArticleAuthors() {
        this.aaindex.setArticleAuthors("authors");
        AAindexTest.assertEquals((String)"authors", (String)this.aaindex.getArticleAuthors());
    }

    public void testGetComment() {
        AAindexTest.assertNull((Object)this.aaindex.getComment());
    }

    public void testSetComment() {
        this.aaindex.setComment("comment");
        AAindexTest.assertEquals((String)"comment", (String)this.aaindex.getComment());
    }

    public void testGetArticleTitle() {
        AAindexTest.assertNull((Object)this.aaindex.getArticleTitle());
    }

    public void testSetArticleTitle() {
        this.aaindex.setArticleTitle("title");
        AAindexTest.assertEquals((String)"title", (String)this.aaindex.getArticleTitle());
    }

    public void testGetDescription() {
        AAindexTest.assertNull((Object)this.aaindex.getDescription());
    }

    public void testSetDescription() {
        this.aaindex.setDescription("description");
        AAindexTest.assertEquals((String)"description", (String)this.aaindex.getDescription());
    }

    public void testGetJournalReference() {
        AAindexTest.assertNull((Object)this.aaindex.getJournalReference());
    }

    public void testSetJournalReference() {
        this.aaindex.setJournalReference("journal");
        AAindexTest.assertEquals((String)"journal", (String)this.aaindex.getJournalReference());
    }

    public void testGetLITDBEntryNumbers() {
        AAindexTest.assertNull((Object)this.aaindex.getLITDBEntryNumbers());
    }

    public void testSetLITDBEntryNumbers() {
        this.aaindex.setLITDBEntryNumbers(new String[]{"lit"});
        AAindexTest.assertEquals((String)"lit", (String)this.aaindex.getLITDBEntryNumbers()[0]);
    }

    public void testSimilarEntries() {
        AAindexTest.assertEquals((int)0, (int)this.aaindex.similarEntries().size());
        this.aaindex.similarEntries().put("test", new Double(0.0));
        AAindexTest.assertEquals((Object)new Double(0.0), this.aaindex.similarEntries().get("test"));
    }

    public void testGetName() {
        AAindexTest.assertEquals((String)"test", (String)this.aaindex.getName());
    }

    public void testGetAlphabet() {
        AAindexTest.assertEquals((Object)ProteinTools.getAlphabet(), (Object)this.aaindex.getAlphabet());
    }

    public void testDoubleValue() throws IllegalSymbolException {
        this.aaindex.setDoubleProperty(ProteinTools.gln(), "1.0");
        AAindexTest.assertEquals((double)1.0, (double)this.aaindex.getDoubleValue(ProteinTools.gln()), (double)0.0);
        try {
            this.aaindex.getDoubleValue(DNATools.a());
            AAindexTest.fail((String)"IllegalSymbolException not thrown.");
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
    }
}

