/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics.aaindex;

import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.aaindex.SimpleSymbolPropertyTableDB;
import org.biojava.bio.proteomics.aaindex.SymbolPropertyTableIterator;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.symbol.SimpleSymbolPropertyTable;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class SimpleSymbolPropertyTableDBTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(SimpleSymbolPropertyTableDBTest.class);
    }

    public void testEmptyConstructor() {
        SimpleSymbolPropertyTableDB db = new SimpleSymbolPropertyTableDB();
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database is not empty.", (int)0, (int)db.numTables());
        SimpleSymbolPropertyTableDBTest.assertFalse((String)"Database does not return an empty iterator.", (boolean)db.tableIterator().hasNext());
    }

    public void testNonEmptyConstructor() throws BioException {
        SimpleSymbolPropertyTableDB dbInit = new SimpleSymbolPropertyTableDB();
        SimpleSymbolPropertyTable t1 = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "protein");
        SimpleSymbolPropertyTable t2 = new SimpleSymbolPropertyTable(DNATools.getDNA(), "dna");
        dbInit.addTable(t1);
        dbInit.addTable(t2);
        SimpleSymbolPropertyTableDB db = new SimpleSymbolPropertyTableDB(dbInit.tableIterator());
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database has wrong number of tables.", (int)2, (int)db.numTables());
        SymbolPropertyTableIterator iterator = db.tableIterator();
        ArrayList<SymbolPropertyTable> tables = new ArrayList<SymbolPropertyTable>(2);
        while (iterator.hasNext()) {
            tables.add(iterator.nextTable());
        }
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Iterator returned wrong number of tables.", (int)2, (int)tables.size());
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Iterator returned wrong table.", (Object)t1, tables.get(0));
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Iterator returned wrong table.", (Object)t2, tables.get(1));
    }

    public void testAddTable() throws IllegalIDException {
        SimpleSymbolPropertyTableDB db = new SimpleSymbolPropertyTableDB();
        SimpleSymbolPropertyTable t1 = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "protein");
        SimpleSymbolPropertyTable t2 = new SimpleSymbolPropertyTable(DNATools.getDNA(), "dna");
        db.addTable(t1);
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database has wrong number of tables.", (int)1, (int)db.numTables());
        db.addTable(t2);
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database has wrong number of tables.", (int)2, (int)db.numTables());
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database returned wrong table.", (Object)t1, (Object)db.table("protein"));
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database returned wrong table.", (Object)t2, (Object)db.table("dna"));
        Set names = db.names();
        SimpleSymbolPropertyTableDBTest.assertTrue((String)"Table is missing.", (boolean)names.contains("protein"));
        SimpleSymbolPropertyTableDBTest.assertTrue((String)"Table is missing.", (boolean)names.contains("dna"));
        SimpleSymbolPropertyTableDBTest.assertEquals((String)"Database has wrong number of tables.", (int)2, (int)names.size());
        try {
            db.addTable(null);
            SimpleSymbolPropertyTableDBTest.fail((String)"addTable must throw NullPointerException.");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void testTable() {
        SimpleSymbolPropertyTableDB db = new SimpleSymbolPropertyTableDB();
        try {
            db.table(null);
            SimpleSymbolPropertyTableDBTest.fail((String)"table must throw NullPointerException.");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalIDException e) {
            SimpleSymbolPropertyTableDBTest.fail((String)"table throwed IllegalIDException instead of NullPointerException.");
        }
        try {
            db.table("test");
            SimpleSymbolPropertyTableDBTest.fail((String)"table must throw IllegalIDException.");
        }
        catch (IllegalIDException e) {
            e.printStackTrace();
        }
    }
}

