/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import junit.framework.TestCase;
import org.biojava.bio.search.MaxMismatchPattern;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public class MaxMismatchPatternTest
extends TestCase {
    public void testTooShort() throws IllegalSymbolException, IllegalAlphabetException {
        SymbolList zero = DNATools.createDNA("");
        SymbolList one = DNATools.createDNA("a");
        SymbolList agct = DNATools.createDNA("agct");
        SymbolList aggt = DNATools.createDNA("aggt");
        MaxMismatchPattern mmp = new MaxMismatchPattern(agct, 0);
        MaxMismatchPatternTest.assertFalse((String)"Zero length string has no matches", (boolean)mmp.matcher(zero).find());
        MaxMismatchPatternTest.assertFalse((String)"One length string has no matches", (boolean)mmp.matcher(one).find());
        MaxMismatchPatternTest.assertTrue((String)"Four length identical string has a match", (boolean)mmp.matcher(agct).find());
        MaxMismatchPatternTest.assertFalse((String)"Four length non-identical string has no match", (boolean)mmp.matcher(aggt).find());
    }
}

