/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import junit.framework.TestCase;
import org.biojava.bio.search.BioMatcher;
import org.biojava.bio.search.SeqContentPattern;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public class SeqContentPatternTest
extends TestCase {
    public void testTooShort() throws IllegalSymbolException, IllegalAlphabetException {
        SymbolList zero = DNATools.createDNA("");
        SymbolList one = DNATools.createDNA("a");
        SymbolList five = DNATools.createDNA("aaaaa");
        SymbolList sixMatch = DNATools.createDNA("aaaaaa");
        SymbolList sixNoMatch = DNATools.createDNA("tttttt");
        SymbolList sevenMatch1 = DNATools.createDNA("aaaaaat");
        SymbolList sevenMatch2 = DNATools.createDNA("taaaaaa");
        SymbolList sevenMatchAll = DNATools.createDNA("aaaaaaa");
        SymbolList sevenNoMatch = DNATools.createDNA("ttttttt");
        SeqContentPattern scp = new SeqContentPattern(DNATools.getDNA());
        scp.setLength(6);
        scp.setMinCounts(DNATools.a(), 6);
        BioMatcher scm = scp.matcher(zero);
        SeqContentPatternTest.assertFalse((String)"No hits of length 6 in seq length 0", (boolean)scm.find());
        scm = scp.matcher(one);
        SeqContentPatternTest.assertFalse((String)"No hits of length 6 in seq length 1", (boolean)scm.find());
        scm = scp.matcher(five);
        SeqContentPatternTest.assertFalse((String)"No hits of length 6 in seq length 5", (boolean)scm.find());
        scm = scp.matcher(sixMatch);
        SeqContentPatternTest.assertTrue((String)"Hit found in matching 6", (boolean)scm.find());
        SeqContentPatternTest.assertFalse((String)"Just the one hit", (boolean)scm.find());
        scm = scp.matcher(sixNoMatch);
        SeqContentPatternTest.assertFalse((String)"No hit in non-matching 6", (boolean)scm.find());
        scm = scp.matcher(sevenMatch1);
        SeqContentPatternTest.assertTrue((String)"Hit in 7-1", (boolean)scm.find());
        SeqContentPatternTest.assertEquals((String)"Hit in 7-1 at 1", (int)1, (int)scm.start());
        SeqContentPatternTest.assertFalse((String)"No more hits in 7-1", (boolean)scm.find());
        scm = scp.matcher(sevenMatch2);
        SeqContentPatternTest.assertTrue((String)"Hit in 7-2", (boolean)scm.find());
        SeqContentPatternTest.assertEquals((String)"Hit in 7-2 at 2", (int)2, (int)scm.start());
        SeqContentPatternTest.assertFalse((String)"No more hits in 7-2", (boolean)scm.find());
        scm = scp.matcher(sevenMatchAll);
        SeqContentPatternTest.assertTrue((String)"Hit in 7-all", (boolean)scm.find());
        SeqContentPatternTest.assertEquals((String)"Hit in 7-all at 1", (int)1, (int)scm.start());
        SeqContentPatternTest.assertTrue((String)"Hit in 7-all", (boolean)scm.find());
        SeqContentPatternTest.assertEquals((String)"Hit in 7-all at 2", (int)2, (int)scm.start());
        scm = scp.matcher(sevenNoMatch);
        SeqContentPatternTest.assertFalse((String)"No hit in seven no hits", (boolean)scm.find());
    }
}

