/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SimpleSeqSimilaritySearchHit;
import org.biojava.bio.search.SimpleSeqSimilaritySearchSubHit;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;

public class SimpleSeqSimilaritySearchHitTest
extends TestCase {
    private SeqSimilaritySearchHit h1;
    private SeqSimilaritySearchHit h2;
    private List subHits1;
    private List subHits2;
    private Alignment al1;
    private Alignment al2;
    private double score = 100.0;
    private double eValue = 1.0E-10;
    private double pValue = 1.0E-10;
    private int queryStart = 1;
    private int queryEnd = 10;
    private StrandedFeature.Strand querySeqStrand = StrandedFeature.POSITIVE;
    private int subjectStart = 2;
    private int subjectEnd = 8;
    private StrandedFeature.Strand subjectSeqStrand = StrandedFeature.POSITIVE;
    private String subjectID = "subjectID";
    private String querySeqTokens = "TRYPASNDEF";
    private String subjectSeqTokens = "-RYPASND--";

    public SimpleSeqSimilaritySearchHitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        SymbolTokenization tp = ProteinTools.getAlphabet().getTokenization("token");
        HashMap<String, SimpleSymbolList> labelMap1 = new HashMap<String, SimpleSymbolList>();
        labelMap1.put("Query", new SimpleSymbolList(tp, this.querySeqTokens));
        labelMap1.put(this.subjectID, new SimpleSymbolList(tp, this.subjectSeqTokens));
        this.al1 = new SimpleAlignment(labelMap1);
        HashMap<String, SimpleSymbolList> labelMap2 = new HashMap<String, SimpleSymbolList>();
        labelMap2.put("Query", new SimpleSymbolList(tp, this.querySeqTokens));
        labelMap2.put(this.subjectID, new SimpleSymbolList(tp, this.subjectSeqTokens));
        this.al2 = new SimpleAlignment(labelMap2);
        this.subHits1 = new ArrayList();
        this.subHits1.add(new SimpleSeqSimilaritySearchSubHit(this.score, this.eValue, this.pValue, this.queryStart, this.queryEnd, this.querySeqStrand, this.subjectStart, this.subjectEnd, this.subjectSeqStrand, this.al1, Annotation.EMPTY_ANNOTATION));
        this.subHits2 = new ArrayList();
        this.subHits2.add(new SimpleSeqSimilaritySearchSubHit(this.score, this.eValue, this.pValue, this.queryStart, this.queryEnd, this.querySeqStrand, this.subjectStart, this.subjectEnd, this.subjectSeqStrand, this.al2, Annotation.EMPTY_ANNOTATION));
        this.h1 = new SimpleSeqSimilaritySearchHit(this.score, this.eValue, this.pValue, this.queryStart, this.queryEnd, this.querySeqStrand, this.subjectStart, this.subjectEnd, this.subjectSeqStrand, this.subjectID, Annotation.EMPTY_ANNOTATION, this.subHits1);
        this.h2 = new SimpleSeqSimilaritySearchHit(this.score, this.eValue, this.pValue, this.queryStart, this.queryEnd, this.querySeqStrand, this.subjectStart, this.subjectEnd, this.subjectSeqStrand, this.subjectID, Annotation.EMPTY_ANNOTATION, this.subHits2);
    }

    public void testEquals() {
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h1, (Object)this.h1);
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h2, (Object)this.h2);
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h1, (Object)this.h2);
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h2, (Object)this.h1);
    }

    public void testScores() {
        SimpleSeqSimilaritySearchHitTest.assertEquals((double)this.h1.getScore(), (double)100.0, (double)0.0);
        SimpleSeqSimilaritySearchHitTest.assertEquals((double)this.h1.getEValue(), (double)1.0E-10, (double)0.0);
        SimpleSeqSimilaritySearchHitTest.assertEquals((double)this.h1.getPValue(), (double)1.0E-10, (double)0.0);
    }

    public void testQuery() {
        SimpleSeqSimilaritySearchHitTest.assertEquals((int)this.h1.getQueryStart(), (int)1);
        SimpleSeqSimilaritySearchHitTest.assertEquals((int)this.h1.getQueryEnd(), (int)10);
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h1.getQueryStrand(), (Object)StrandedFeature.POSITIVE);
    }

    public void testSubject() {
        SimpleSeqSimilaritySearchHitTest.assertEquals((int)this.h1.getSubjectStart(), (int)2);
        SimpleSeqSimilaritySearchHitTest.assertEquals((int)this.h1.getSubjectEnd(), (int)8);
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h1.getSubjectStrand(), (Object)StrandedFeature.POSITIVE);
    }

    public void testID() {
        SimpleSeqSimilaritySearchHitTest.assertEquals((String)this.h1.getSubjectID(), (String)"subjectID");
    }

    public void testAnnotation() {
        SimpleSeqSimilaritySearchHitTest.assertEquals((Object)this.h1.getAnnotation(), (Object)Annotation.EMPTY_ANNOTATION);
    }
}

