/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.search.SimpleSeqSimilaritySearchResult;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.SimpleSymbolList;

public class SimpleSeqSimilaritySearchResultTest
extends TestCase {
    private SeqSimilaritySearchResult r1;
    private SeqSimilaritySearchResult r2;
    private SequenceDB database;
    private Map parameters;
    private Sequence query;
    private String querySeqTokens = "TRYPASNDEF";

    public SimpleSeqSimilaritySearchResultTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.database = new HashSequenceDB("test");
        this.parameters = new HashMap();
        SymbolTokenization tp = ProteinTools.getAlphabet().getTokenization("token");
        this.query = new SimpleSequence(new SimpleSymbolList(tp, this.querySeqTokens), "query", "", Annotation.EMPTY_ANNOTATION);
        this.r1 = new SimpleSeqSimilaritySearchResult(this.query, this.database, this.parameters, new ArrayList(), Annotation.EMPTY_ANNOTATION);
        this.r2 = new SimpleSeqSimilaritySearchResult(this.query, this.database, this.parameters, new ArrayList(), Annotation.EMPTY_ANNOTATION);
    }

    public void testEquals() {
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r1, (Object)this.r1);
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r2, (Object)this.r2);
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r1, (Object)this.r2);
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r2, (Object)this.r1);
    }

    public void testSequenceDB() {
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r1.getSequenceDB(), (Object)this.database);
    }

    public void testSearchParameters() {
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r1.getSearchParameters(), (Object)this.parameters);
    }

    public void testQuerySequence() {
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r1.getQuerySequence(), (Object)this.query);
    }

    public void testAnnotation() {
        SimpleSeqSimilaritySearchResultTest.assertEquals((Object)this.r1.getAnnotation(), (Object)Annotation.EMPTY_ANNOTATION);
    }
}

