/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.HashMap;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchSubHit;
import org.biojava.bio.search.SimpleSeqSimilaritySearchSubHit;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;

public class SimpleSeqSimilaritySearchSubHitTest
extends TestCase {
    private SeqSimilaritySearchSubHit sh1;
    private SeqSimilaritySearchSubHit sh2;
    private Alignment al1;
    private Alignment al2;
    private double score = 100.0;
    private double eValue = 1.0E-10;
    private double pValue = 1.0E-10;
    private int queryStart = 1;
    private int queryEnd = 10;
    private StrandedFeature.Strand querySeqStrand = StrandedFeature.POSITIVE;
    private int subjectStart = 2;
    private int subjectEnd = 8;
    private StrandedFeature.Strand subjectSeqStrand = StrandedFeature.POSITIVE;
    private String subjectID = "subjectID";
    private String querySeqTokens = "TRYPASNDEF";
    private String subjectSeqTokens = "-RYPASND--";

    public SimpleSeqSimilaritySearchSubHitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        SymbolTokenization tp = ProteinTools.getAlphabet().getTokenization("token");
        HashMap<String, SimpleSymbolList> labelMap1 = new HashMap<String, SimpleSymbolList>();
        labelMap1.put("Query", new SimpleSymbolList(tp, this.querySeqTokens));
        labelMap1.put(this.subjectID, new SimpleSymbolList(tp, this.subjectSeqTokens));
        this.al1 = new SimpleAlignment(labelMap1);
        HashMap<String, SimpleSymbolList> labelMap2 = new HashMap<String, SimpleSymbolList>();
        labelMap2.put("Query", new SimpleSymbolList(tp, this.querySeqTokens));
        labelMap2.put(this.subjectID, new SimpleSymbolList(tp, this.subjectSeqTokens));
        this.al2 = new SimpleAlignment(labelMap2);
        this.sh1 = new SimpleSeqSimilaritySearchSubHit(this.score, this.eValue, this.pValue, this.queryStart, this.queryEnd, this.querySeqStrand, this.subjectStart, this.subjectEnd, this.subjectSeqStrand, this.al1, Annotation.EMPTY_ANNOTATION);
        this.sh2 = new SimpleSeqSimilaritySearchSubHit(this.score, this.eValue, this.pValue, this.queryStart, this.queryEnd, this.querySeqStrand, this.subjectStart, this.subjectEnd, this.subjectSeqStrand, this.al2, Annotation.EMPTY_ANNOTATION);
    }

    public void testEquals() {
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh1, (Object)this.sh1);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh2, (Object)this.sh2);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh1, (Object)this.sh2);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh2, (Object)this.sh1);
    }

    public void testScores() {
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((double)this.sh1.getScore(), (double)100.0, (double)0.0);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((double)this.sh1.getEValue(), (double)1.0E-10, (double)0.0);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((double)this.sh1.getPValue(), (double)1.0E-10, (double)0.0);
    }

    public void testQuery() {
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((int)this.sh1.getQueryStart(), (int)1);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((int)this.sh1.getQueryEnd(), (int)10);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh1.getQueryStrand(), (Object)StrandedFeature.POSITIVE);
    }

    public void testSubject() {
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((int)this.sh1.getSubjectStart(), (int)2);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((int)this.sh1.getSubjectEnd(), (int)8);
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh1.getSubjectStrand(), (Object)StrandedFeature.POSITIVE);
    }

    public void testAnnotation() {
        SimpleSeqSimilaritySearchSubHitTest.assertEquals((Object)this.sh1.getAnnotation(), (Object)Annotation.EMPTY_ANNOTATION);
    }
}

