/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.biojava.bio.seq.CircularView;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.CircularLocation;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class CircularSequenceTest
extends TestCase {
    protected Sequence dna;
    protected CircularView circ;
    protected Symbol a = DNATools.a();
    protected Symbol c = DNATools.c();
    protected Symbol g = DNATools.g();
    protected Symbol t = DNATools.t();

    public CircularSequenceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.dna = DNATools.createDNASequence("atcgctcaga", "");
        this.circ = new CircularView(this.dna);
    }

    public void testLocations() {
        CircularLocation cloc = LocationTools.makeCircularLocation(1, 5, this.dna.length());
        CircularSequenceTest.assertEquals((String)"atcgc", (String)cloc.symbols(this.dna).seqString());
        cloc = LocationTools.makeCircularLocation(1, 10, this.dna.length());
        CircularSequenceTest.assertEquals((String)"atcgctcaga", (String)cloc.symbols(this.dna).seqString());
        cloc = LocationTools.makeCircularLocation(9, 1, this.dna.length());
        CircularSequenceTest.assertTrue((cloc.get5PrimeEnd() == 9 ? 1 : 0) != 0);
        CircularSequenceTest.assertEquals((String)"gaa", (String)cloc.symbols(this.dna).seqString());
        ArrayList<CircularLocation> l = new ArrayList<CircularLocation>();
        l.add(LocationTools.makeCircularLocation(5, 6, this.dna.length()));
        l.add(LocationTools.makeCircularLocation(9, 1, this.dna.length()));
        l.add(LocationTools.makeCircularLocation(3, 3, this.dna.length()));
        cloc = (CircularLocation)LocationTools.union(l);
        CircularSequenceTest.assertTrue((cloc.get5PrimeEnd() == 5 ? 1 : 0) != 0);
        CircularSequenceTest.assertEquals((String)"ctgaac", (String)cloc.symbols(this.dna).seqString());
    }

    public void testSubStr() {
        CircularSequenceTest.assertEquals((String)"atc", (String)this.circ.subStr(1, 3));
        CircularSequenceTest.assertEquals((String)"aat", (String)this.circ.subStr(0, 2));
        CircularSequenceTest.assertEquals((String)"agaatc", (String)this.circ.subStr(-2, 3));
        CircularSequenceTest.assertEquals((String)"gaatc", (String)this.circ.subStr(9, 3));
        CircularSequenceTest.assertEquals((String)"gaatc", (String)this.circ.subStr(9, 13));
    }

    public void testSymbolAt() {
        CircularSequenceTest.assertEquals((Object)this.a, (Object)this.circ.symbolAt(0));
        CircularSequenceTest.assertEquals((Object)this.c, (Object)this.circ.symbolAt(13));
        CircularSequenceTest.assertEquals((Object)this.g, (Object)this.circ.symbolAt(-1));
        CircularSequenceTest.assertEquals((Object)this.t, (Object)this.circ.symbolAt(-4));
    }

    public void testSubList() throws Exception {
        SymbolList s = DNATools.createDNA("agaatc");
        CircularSequenceTest.assertTrue((boolean)s.equals(this.circ.subList(-2, 3)));
        CircularSequenceTest.assertTrue((boolean)this.symsEq(this.circ.subList(-2, 2), this.circ.subList(8, 12)));
    }

    private boolean symsEq(SymbolList a, SymbolList b) {
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 1; i <= a.length(); ++i) {
            if (a.symbolAt(i) == b.symbolAt(i)) continue;
            return false;
        }
        return true;
    }
}

