/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SymbolList;

public class DNAToolsTest
extends TestCase {
    protected SymbolTokenization dnaTokens;

    public DNAToolsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.dnaTokens = AlphabetManager.alphabetForName("DNA").getTokenization("token");
    }

    public void testSymbols() throws Exception {
        DNAToolsTest.assertEquals((String)"a", (String)this.dnaTokens.tokenizeSymbol(DNATools.a()));
        DNAToolsTest.assertEquals((String)"g", (String)this.dnaTokens.tokenizeSymbol(DNATools.g()));
        DNAToolsTest.assertEquals((String)"c", (String)this.dnaTokens.tokenizeSymbol(DNATools.c()));
        DNAToolsTest.assertEquals((String)"t", (String)this.dnaTokens.tokenizeSymbol(DNATools.t()));
        DNAToolsTest.assertEquals((String)"n", (String)this.dnaTokens.tokenizeSymbol(DNATools.n()));
    }

    public void testGetDNA() {
        DNAToolsTest.assertEquals((Object)AlphabetManager.alphabetForName("DNA"), (Object)DNATools.getDNA());
    }

    public void testGetCodon() {
        List<FiniteAlphabet> l = Collections.nCopies(3, DNATools.getDNA());
        DNAToolsTest.assertEquals((Object)DNATools.getCodonAlphabet(), (Object)AlphabetManager.getCrossProductAlphabet(l));
    }

    public void testCreateDNA() throws Exception {
        SymbolList dnaSyms = DNATools.createDNA("agctn");
        DNAToolsTest.assertEquals((int)5, (int)dnaSyms.length());
        DNAToolsTest.assertEquals((String)"a", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(1)));
        DNAToolsTest.assertEquals((String)"g", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(2)));
        DNAToolsTest.assertEquals((String)"c", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(3)));
        DNAToolsTest.assertEquals((String)"t", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(4)));
        DNAToolsTest.assertEquals((String)"n", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(5)));
    }

    public void testIndex() throws Exception {
        DNAToolsTest.assertEquals((int)0, (int)DNATools.index(DNATools.a()));
        DNAToolsTest.assertEquals((int)1, (int)DNATools.index(DNATools.g()));
        DNAToolsTest.assertEquals((int)2, (int)DNATools.index(DNATools.c()));
        DNAToolsTest.assertEquals((int)3, (int)DNATools.index(DNATools.t()));
    }

    public void testForIndex() {
        DNAToolsTest.assertEquals((Object)DNATools.a(), (Object)DNATools.forIndex(0));
        DNAToolsTest.assertEquals((Object)DNATools.g(), (Object)DNATools.forIndex(1));
        DNAToolsTest.assertEquals((Object)DNATools.c(), (Object)DNATools.forIndex(2));
        DNAToolsTest.assertEquals((Object)DNATools.t(), (Object)DNATools.forIndex(3));
    }

    public void testComplement() throws Exception {
        DNAToolsTest.assertEquals((Object)DNATools.a(), (Object)DNATools.complement(DNATools.t()));
        DNAToolsTest.assertEquals((Object)DNATools.g(), (Object)DNATools.complement(DNATools.c()));
        DNAToolsTest.assertEquals((Object)DNATools.c(), (Object)DNATools.complement(DNATools.g()));
        DNAToolsTest.assertEquals((Object)DNATools.t(), (Object)DNATools.complement(DNATools.a()));
        DNAToolsTest.assertEquals((Object)DNATools.n(), (Object)DNATools.complement(DNATools.n()));
        SymbolList dnaSyms = DNATools.complement(DNATools.createDNA("agctn"));
        DNAToolsTest.assertEquals((int)5, (int)dnaSyms.length());
        DNAToolsTest.assertEquals((String)"t", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(1)));
        DNAToolsTest.assertEquals((String)"c", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(2)));
        DNAToolsTest.assertEquals((String)"g", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(3)));
        DNAToolsTest.assertEquals((String)"a", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(4)));
        DNAToolsTest.assertEquals((String)"n", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(5)));
    }

    public void testForSymbol() throws Exception {
        DNAToolsTest.assertEquals((String)"a", (String)this.dnaTokens.tokenizeSymbol(DNATools.forSymbol('a')));
        DNAToolsTest.assertEquals((String)"g", (String)this.dnaTokens.tokenizeSymbol(DNATools.forSymbol('g')));
        DNAToolsTest.assertEquals((String)"c", (String)this.dnaTokens.tokenizeSymbol(DNATools.forSymbol('c')));
        DNAToolsTest.assertEquals((String)"t", (String)this.dnaTokens.tokenizeSymbol(DNATools.forSymbol('t')));
    }

    public void testReverseComplement() throws Exception {
        SymbolList dnaSyms = DNATools.reverseComplement(DNATools.createDNA("agctn"));
        DNAToolsTest.assertEquals((int)5, (int)dnaSyms.length());
        DNAToolsTest.assertEquals((String)"n", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(1)));
        DNAToolsTest.assertEquals((String)"a", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(2)));
        DNAToolsTest.assertEquals((String)"g", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(3)));
        DNAToolsTest.assertEquals((String)"c", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(4)));
        DNAToolsTest.assertEquals((String)"t", (String)this.dnaTokens.tokenizeSymbol(dnaSyms.symbolAt(5)));
    }

    public void testDNAToken() throws Exception {
        DNAToolsTest.assertEquals((char)'a', (char)DNATools.dnaToken(DNATools.a()));
        DNAToolsTest.assertEquals((char)'g', (char)DNATools.dnaToken(DNATools.g()));
        DNAToolsTest.assertEquals((char)'c', (char)DNATools.dnaToken(DNATools.c()));
        DNAToolsTest.assertEquals((char)'t', (char)DNATools.dnaToken(DNATools.t()));
        DNAToolsTest.assertEquals((char)'n', (char)DNATools.dnaToken(DNATools.n()));
    }
}

