/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public class FeatureFilterTest
extends TestCase {
    protected Sequence seq;
    protected Location complexLocation;
    protected Feature fooFeature;
    protected Feature complexFeature;

    public FeatureFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.seq = new SimpleSequence(DNATools.createDNA("gattaca"), "foo", "foo", Annotation.EMPTY_ANNOTATION);
        StrandedFeature.Template template = new StrandedFeature.Template();
        template.type = "foo";
        template.source = "bar";
        template.location = new RangeLocation(2, 5);
        template.strand = StrandedFeature.POSITIVE;
        template.annotation = new SmallAnnotation();
        template.annotation.setProperty("baz", Boolean.TRUE);
        this.fooFeature = this.seq.createFeature(template);
        this.complexLocation = LocationTools.union(new RangeLocation(1, 2), new RangeLocation(5, 6));
        template.type = "complex";
        template.location = this.complexLocation;
        this.complexFeature = this.seq.createFeature(template);
    }

    public void testHasAnnotation() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.HasAnnotation("baz").accept(this.fooFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.HasAnnotation("evil").accept(this.fooFeature) ? 1 : 0) != 0);
    }

    public void testByAnnotation() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ByAnnotation("baz", Boolean.TRUE).accept(this.fooFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.ByAnnotation("baz", Boolean.FALSE).accept(this.fooFeature) ? 1 : 0) != 0);
        FeatureFilterTest.assertTrue((!new FeatureFilter.ByAnnotation("evil", Boolean.TRUE).accept(this.fooFeature) ? 1 : 0) != 0);
    }

    public void testByType() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ByType("foo").accept(this.fooFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.ByType("evil").accept(this.fooFeature) ? 1 : 0) != 0);
    }

    public void testBySource() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.BySource("bar").accept(this.fooFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.BySource("evil").accept(this.fooFeature) ? 1 : 0) != 0);
    }

    public void testOverlapsLocation() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.OverlapsLocation(new RangeLocation(1, 6)).accept(this.fooFeature));
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.OverlapsLocation(new RangeLocation(3, 6)).accept(this.fooFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.OverlapsLocation(new RangeLocation(1, 1)).accept(this.fooFeature) ? 1 : 0) != 0);
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.OverlapsLocation(new PointLocation(1)).accept(this.complexFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.OverlapsLocation(new PointLocation(3)).accept(this.complexFeature) ? 1 : 0) != 0);
    }

    public void testContainedByLocation() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ContainedByLocation(new RangeLocation(1, 6)).accept(this.fooFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.ContainedByLocation(new RangeLocation(3, 6)).accept(this.fooFeature) ? 1 : 0) != 0);
        FeatureFilterTest.assertTrue((!new FeatureFilter.ContainedByLocation(new RangeLocation(1, 1)).accept(this.fooFeature) ? 1 : 0) != 0);
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ContainedByLocation(new RangeLocation(1, 6)).accept(this.complexFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.ContainedByLocation(new RangeLocation(1, 2)).accept(this.complexFeature) ? 1 : 0) != 0);
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ContainedByLocation(this.complexLocation).accept(this.complexFeature));
    }

    public void testShadowOverlapsLocation() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ShadowOverlapsLocation(new PointLocation(1)).accept(this.complexFeature));
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ShadowOverlapsLocation(new PointLocation(3)).accept(this.complexFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.ShadowOverlapsLocation(new PointLocation(7)).accept(this.complexFeature) ? 1 : 0) != 0);
    }

    public void testShadowContainedByLocation() {
        FeatureFilterTest.assertTrue((boolean)new FeatureFilter.ShadowContainedByLocation(new RangeLocation(1, 6)).accept(this.complexFeature));
        FeatureFilterTest.assertTrue((!new FeatureFilter.ShadowContainedByLocation(new RangeLocation(1, 2)).accept(this.complexFeature) ? 1 : 0) != 0);
        FeatureFilterTest.assertTrue((!new FeatureFilter.ShadowContainedByLocation(this.complexLocation).accept(this.complexFeature) ? 1 : 0) != 0);
    }
}

