/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureHolderUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class FeatureHolderUtilsTest
extends TestCase {
    protected Feature f1;
    protected Feature f2;
    protected Feature f3;
    protected SimpleFeatureHolder fh1;
    protected SimpleFeatureHolder fh2;

    protected void setUp() throws Exception {
        Sequence seq = DNATools.createDNASequence("attagagg", "seq");
        this.f1 = this.generateFeatures(seq, "f1");
        this.f2 = this.generateFeatures(seq, "f2");
        this.f3 = this.generateFeatures(seq, "f3");
        this.fh1 = new SimpleFeatureHolder();
        this.fh1.addFeature(this.f1);
        this.fh1.addFeature(this.f2);
        this.fh2 = new SimpleFeatureHolder();
        this.fh2.addFeature(this.f2);
        this.fh2.addFeature(this.f3);
    }

    public void testUnion() throws ChangeVetoException {
        FeatureHolder fh = FeatureHolderUtils.union(this.fh1, this.fh2);
        FeatureHolderUtilsTest.assertTrue((boolean)fh.containsFeature(this.f1));
        FeatureHolderUtilsTest.assertTrue((boolean)fh.containsFeature(this.f2));
        FeatureHolderUtilsTest.assertTrue((boolean)fh.containsFeature(this.f3));
        FeatureHolderUtilsTest.assertEquals((int)3, (int)fh.countFeatures());
    }

    public void testIntersect() throws ChangeVetoException {
        FeatureHolder fh = FeatureHolderUtils.intersect(this.fh1, this.fh2);
        FeatureHolderUtilsTest.assertTrue((boolean)fh.containsFeature(this.f2));
        FeatureHolderUtilsTest.assertFalse((boolean)fh.containsFeature(this.f1));
        FeatureHolderUtilsTest.assertFalse((boolean)fh.containsFeature(this.f3));
        FeatureHolderUtilsTest.assertEquals((int)1, (int)fh.countFeatures());
    }

    public void testNot() throws ChangeVetoException {
        FeatureHolder fh = FeatureHolderUtils.not(this.fh1, this.fh2);
        FeatureHolderUtilsTest.assertTrue((boolean)fh.containsFeature(this.f1));
        FeatureHolderUtilsTest.assertFalse((boolean)fh.containsFeature(this.f2));
        FeatureHolderUtilsTest.assertFalse((boolean)fh.containsFeature(this.f3));
        FeatureHolderUtilsTest.assertEquals((int)1, (int)fh.countFeatures());
    }

    public void testFeatureHolderAsSet() {
        Set set = FeatureHolderUtils.featureHolderAsSet(this.fh1);
        FeatureHolderUtilsTest.assertTrue((boolean)set.contains(this.f1));
        FeatureHolderUtilsTest.assertTrue((boolean)set.contains(this.f2));
        FeatureHolderUtilsTest.assertFalse((boolean)set.contains(this.f3));
        set.add(this.f3);
        FeatureHolderUtilsTest.assertTrue((boolean)set.contains(this.f3));
        set.remove(this.f3);
        FeatureHolderUtilsTest.assertFalse((boolean)set.contains(this.f3));
    }

    private Feature generateFeatures(FeatureHolder fh, String type) throws BioException, ChangeVetoException {
        StrandedFeature.Template templ = new StrandedFeature.Template();
        templ.type = type;
        templ.location = new RangeLocation(1, 5);
        templ.strand = StrandedFeature.POSITIVE;
        templ.source = "foo";
        templ.annotation = Annotation.EMPTY_ANNOTATION;
        return fh.createFeature(templ);
    }
}

