/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import junit.framework.TestCase;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.homol.HomologyFeature;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public class FilterUtilsTest
extends TestCase {
    protected FeatureFilter all_and_all;
    protected FeatureFilter all_and_none;
    protected FeatureFilter none_and_all;
    protected FeatureFilter none_and_none;
    protected FeatureFilter all_or_all;
    protected FeatureFilter all_or_none;
    protected FeatureFilter none_or_all;
    protected FeatureFilter none_or_none;
    protected FeatureFilter tf1;
    protected FeatureFilter tf2;
    protected FeatureFilter tf3;
    protected FeatureFilter pf1;
    protected FeatureFilter pf2;
    protected FeatureFilter pf3;
    protected FeatureFilter pf4;
    protected FeatureFilter pf5;
    protected FeatureFilter pf6;
    protected FeatureFilter cf_StrandedFeature;
    protected FeatureFilter cf_ComponentFeature;
    protected FeatureFilter cf_HomologyFeature;
    protected FeatureFilter parent_cf_ComponentFeature;
    protected FeatureFilter ancestor_cf_ComponentFeature;
    protected FeatureFilter not_parent_cf_ComponentFeature;
    protected FeatureFilter not_ancestor_cf_ComponentFeature;
    protected FeatureFilter ntf1;
    protected FeatureFilter ntf2;
    protected FeatureFilter olf1;
    protected FeatureFilter olf2;
    protected FeatureFilter olf3;
    protected FeatureFilter olf4;
    protected FeatureFilter clf1;
    protected FeatureFilter clf2;
    protected FeatureFilter clf3;
    protected FeatureFilter clf4;
    protected FeatureFilter tf1_or_tf2;
    protected FeatureFilter tf2_or_tf3;
    protected FeatureFilter tf1_or_tf3;
    protected FeatureFilter tf1_or_tf2_or_tf3;
    protected FeatureFilter pf1_and_pf2;
    protected FeatureFilter pf2_and_pf3;
    protected FeatureFilter pf1_and_pf3;
    protected FeatureFilter pf1_and_pf2_and_pf3;
    protected FeatureFilter pf1_and_tf1;
    protected FeatureFilter pf1_and_pf2_and_tf1;
    protected FeatureFilter pf1_AND_tf1_or_tf2;
    protected FeatureFilter pf1_and_pf2_OR_tf1;

    public FilterUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.all_and_all = new FeatureFilter.And(FeatureFilter.all, FeatureFilter.all);
        this.all_and_none = new FeatureFilter.And(FeatureFilter.all, FeatureFilter.none);
        this.none_and_all = new FeatureFilter.And(FeatureFilter.none, FeatureFilter.all);
        this.none_and_none = new FeatureFilter.And(FeatureFilter.none, FeatureFilter.none);
        this.all_or_all = new FeatureFilter.Or(FeatureFilter.all, FeatureFilter.all);
        this.all_or_none = new FeatureFilter.Or(FeatureFilter.all, FeatureFilter.none);
        this.none_or_all = new FeatureFilter.Or(FeatureFilter.none, FeatureFilter.all);
        this.none_or_none = new FeatureFilter.Or(FeatureFilter.none, FeatureFilter.none);
        this.tf1 = new FeatureFilter.ByType("hello");
        this.tf2 = new FeatureFilter.ByType("goodbye");
        this.tf3 = new FeatureFilter.ByType("moo");
        this.pf1 = new FeatureFilter.HasAnnotation("foo");
        this.pf2 = new FeatureFilter.HasAnnotation("bar");
        this.pf3 = new FeatureFilter.HasAnnotation("baz");
        this.pf4 = new FeatureFilter.ByAnnotation("foo", "fish");
        this.pf5 = new FeatureFilter.ByAnnotation("foo", "cat");
        this.pf6 = new FeatureFilter.ByAnnotation("bar", "fish");
        this.cf_StrandedFeature = new FeatureFilter.ByClass(StrandedFeature.class);
        this.cf_ComponentFeature = new FeatureFilter.ByClass(ComponentFeature.class);
        this.cf_HomologyFeature = new FeatureFilter.ByClass(HomologyFeature.class);
        this.ntf1 = new FeatureFilter.Not(this.tf1);
        this.ntf2 = new FeatureFilter.Not(this.tf2);
        RangeLocation l1 = new RangeLocation(1000, 2000);
        RangeLocation l2 = new RangeLocation(10000, 11000);
        PointLocation l3 = new PointLocation(10500);
        RangeLocation l4 = new RangeLocation(10700, 11700);
        this.olf1 = new FeatureFilter.OverlapsLocation(l1);
        this.olf2 = new FeatureFilter.OverlapsLocation(l2);
        this.olf3 = new FeatureFilter.OverlapsLocation(l3);
        this.olf4 = new FeatureFilter.OverlapsLocation(l4);
        this.clf1 = new FeatureFilter.ContainedByLocation(l1);
        this.clf2 = new FeatureFilter.ContainedByLocation(l2);
        this.clf3 = new FeatureFilter.ContainedByLocation(l3);
        this.clf4 = new FeatureFilter.ContainedByLocation(l4);
        this.tf1_or_tf2 = new FeatureFilter.Or(this.tf1, this.tf2);
        this.tf2_or_tf3 = new FeatureFilter.Or(this.tf2, this.tf3);
        this.tf1_or_tf3 = new FeatureFilter.Or(this.tf1, this.tf3);
        this.tf1_or_tf2_or_tf3 = new FeatureFilter.Or(this.tf1_or_tf2, this.tf3);
        this.pf1_and_pf2 = new FeatureFilter.And(this.pf1, this.pf2);
        this.pf2_and_pf3 = new FeatureFilter.And(this.pf2, this.pf3);
        this.pf1_and_pf3 = new FeatureFilter.And(this.pf1, this.pf3);
        this.pf1_and_pf2_and_pf3 = new FeatureFilter.And(this.pf1_and_pf2, this.pf3);
        this.pf1_and_tf1 = new FeatureFilter.And(this.pf1, this.tf1);
        this.pf1_and_pf2_and_tf1 = new FeatureFilter.And(this.pf1_and_pf2, this.tf1);
        this.pf1_AND_tf1_or_tf2 = new FeatureFilter.And(this.pf1, this.tf1_or_tf2);
        this.pf1_and_pf2_OR_tf1 = new FeatureFilter.Or(this.pf1_and_pf2, this.tf1);
        this.parent_cf_ComponentFeature = new FeatureFilter.ByParent(this.cf_ComponentFeature);
        this.ancestor_cf_ComponentFeature = new FeatureFilter.ByAncestor(this.cf_ComponentFeature);
        this.not_parent_cf_ComponentFeature = new FeatureFilter.Not(this.parent_cf_ComponentFeature);
        this.not_ancestor_cf_ComponentFeature = new FeatureFilter.Not(this.ancestor_cf_ComponentFeature);
    }

    public void testTypes() throws Exception {
        FilterUtilsTest.assertTrue((!FilterUtils.areProperSubset(this.tf1, this.tf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.tf1, this.tf1));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.tf1, this.tf2));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(this.tf1, this.tf1) ? 1 : 0) != 0);
    }

    public void testByClass() throws Exception {
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.cf_HomologyFeature, this.cf_StrandedFeature));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.cf_ComponentFeature, this.cf_StrandedFeature));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.cf_ComponentFeature, this.cf_HomologyFeature));
    }

    public void testLocation() throws Exception {
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.olf1, this.olf1));
        FilterUtilsTest.assertTrue((!FilterUtils.areProperSubset(this.olf1, this.olf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(this.olf1, this.olf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.clf1, this.olf1));
        FilterUtilsTest.assertTrue((!FilterUtils.areProperSubset(this.olf1, this.clf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.olf1, this.clf2));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.clf1, this.olf2));
    }

    public void testNot() throws Exception {
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.ntf1, this.ntf1));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(this.ntf1, this.ntf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.tf1, this.ntf1));
        FilterUtilsTest.assertTrue((!FilterUtils.areProperSubset(this.tf1, this.ntf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(this.tf2, this.ntf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.tf2, this.ntf1));
    }

    public void testOr() throws Exception {
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.tf1, this.tf1_or_tf2));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(this.tf1, this.tf1_or_tf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.tf3, this.tf1_or_tf2));
        FilterUtilsTest.assertTrue((!FilterUtils.areProperSubset(this.tf1_or_tf2, this.tf2_or_tf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(this.tf1_or_tf2, this.tf2_or_tf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.tf1_or_tf2, this.tf1_or_tf2_or_tf3));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.tf2_or_tf3, this.tf1_or_tf2_or_tf3));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.tf1_or_tf3, this.tf1_or_tf2_or_tf3));
    }

    public void testAnd() throws Exception {
        FilterUtilsTest.assertTrue((String)("are subset: " + this.all_and_all + ", " + FeatureFilter.all), (boolean)FilterUtils.areProperSubset(this.all_and_all, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.all_and_all + ", " + FeatureFilter.all), (!FilterUtils.areDisjoint(this.all_and_all, FeatureFilter.all) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + FeatureFilter.all + ", " + this.all_and_all), (boolean)FilterUtils.areProperSubset(FeatureFilter.all, this.all_and_all));
        FilterUtilsTest.assertTrue((String)("not disjoint: " + FeatureFilter.all + ", " + this.all_and_all), (!FilterUtils.areDisjoint(FeatureFilter.all, this.all_and_all) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.all_and_all + ", " + FeatureFilter.none), (!FilterUtils.areProperSubset(this.all_and_all, FeatureFilter.none) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.all_and_all + ", " + FeatureFilter.none), (boolean)FilterUtils.areDisjoint(this.all_and_all, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are subset: " + FeatureFilter.none + ", " + this.all_and_all), (boolean)FilterUtils.areProperSubset(FeatureFilter.none, this.all_and_all));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.none + ", " + this.all_and_all), (boolean)FilterUtils.areDisjoint(FeatureFilter.none, this.all_and_all));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.all_and_none + ", " + FeatureFilter.all), (boolean)FilterUtils.areProperSubset(this.all_and_none, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.all_and_none + ", " + FeatureFilter.all), (boolean)FilterUtils.areDisjoint(this.all_and_none, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("not subset: " + FeatureFilter.all + ", " + this.all_and_none), (!FilterUtils.areProperSubset(FeatureFilter.all, this.all_and_none) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.all + ", " + this.all_and_none), (boolean)FilterUtils.areDisjoint(FeatureFilter.all, this.all_and_none));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.all_and_none + ", " + FeatureFilter.none), (boolean)FilterUtils.areProperSubset(this.all_and_none, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.all_and_none + ", " + FeatureFilter.none), (boolean)FilterUtils.areDisjoint(this.all_and_none, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are subset: " + FeatureFilter.none + ", " + this.all_and_none), (boolean)FilterUtils.areProperSubset(FeatureFilter.none, this.all_and_none));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.none + ", " + this.all_and_none), (boolean)FilterUtils.areDisjoint(FeatureFilter.none, this.all_and_none));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.none_and_all + ", " + FeatureFilter.all), (boolean)FilterUtils.areProperSubset(this.none_and_all, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.none_and_all + ", " + FeatureFilter.all), (boolean)FilterUtils.areDisjoint(this.none_and_all, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("not subset: " + FeatureFilter.all + ", " + this.none_and_all), (!FilterUtils.areProperSubset(FeatureFilter.all, this.none_and_all) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.all + ", " + this.none_and_all), (boolean)FilterUtils.areDisjoint(FeatureFilter.all, this.none_and_all));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.none_and_all + ", " + FeatureFilter.none), (boolean)FilterUtils.areProperSubset(this.none_and_all, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.none_and_all + ", " + FeatureFilter.none), (boolean)FilterUtils.areDisjoint(this.none_and_all, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are subset: " + FeatureFilter.none + ", " + this.none_and_all), (boolean)FilterUtils.areProperSubset(FeatureFilter.none, this.none_and_all));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.none + ", " + this.none_and_all), (boolean)FilterUtils.areDisjoint(FeatureFilter.none, this.none_and_all));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.none_and_none + ", " + FeatureFilter.all), (boolean)FilterUtils.areProperSubset(this.none_and_none, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.none_and_none + ", " + FeatureFilter.all), (boolean)FilterUtils.areDisjoint(this.none_and_none, FeatureFilter.all));
        FilterUtilsTest.assertTrue((String)("not subset: " + FeatureFilter.all + ", " + this.none_and_none), (!FilterUtils.areProperSubset(FeatureFilter.all, this.none_and_none) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.all + ", " + this.none_and_none), (boolean)FilterUtils.areDisjoint(FeatureFilter.all, this.none_and_none));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.none_and_none + ", " + FeatureFilter.none), (boolean)FilterUtils.areProperSubset(this.none_and_none, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.none_and_none + ", " + FeatureFilter.none), (boolean)FilterUtils.areDisjoint(this.none_and_none, FeatureFilter.none));
        FilterUtilsTest.assertTrue((String)("are subset: " + FeatureFilter.none + ", " + this.none_and_none), (boolean)FilterUtils.areProperSubset(FeatureFilter.none, this.none_and_none));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + FeatureFilter.none + ", " + this.none_and_none), (boolean)FilterUtils.areDisjoint(FeatureFilter.none, this.none_and_none));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1_and_pf2 + ", " + this.pf1), (boolean)FilterUtils.areProperSubset(this.pf1_and_pf2, this.pf1));
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf1_and_pf2 + ", " + this.pf1), (!FilterUtils.areDisjoint(this.pf1_and_pf2, this.pf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1_and_pf2 + ", " + this.pf2), (boolean)FilterUtils.areProperSubset(this.pf1_and_pf2, this.pf2));
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf1_and_pf2 + ", " + this.pf2), (!FilterUtils.areDisjoint(this.pf1_and_pf2, this.pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf1_and_pf2 + ", " + this.pf3), (!FilterUtils.areProperSubset(this.pf1_and_pf2, this.pf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf2_and_pf3 + ", " + this.pf1_and_pf2), (!FilterUtils.areProperSubset(this.pf2_and_pf3, this.pf1_and_pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1_and_pf2_and_pf3 + ", " + this.pf1_and_pf2), (boolean)FilterUtils.areProperSubset(this.pf1_and_pf2_and_pf3, this.pf1_and_pf2));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1_and_pf2_and_pf3 + ", " + this.pf2_and_pf3), (boolean)FilterUtils.areProperSubset(this.pf1_and_pf2_and_pf3, this.pf2_and_pf3));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1_and_pf2_and_tf1 + ", " + this.pf1_and_pf2), (boolean)FilterUtils.areProperSubset(this.pf1_and_pf2_and_tf1, this.pf1_and_pf2));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1_and_pf2_and_tf1 + ", " + this.pf1_and_tf1), (boolean)FilterUtils.areProperSubset(this.pf1_and_pf2_and_tf1, this.pf1_and_tf1));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.pf1_and_tf1 + ", " + this.tf2), (boolean)FilterUtils.areDisjoint(this.pf1_and_tf1, this.tf2));
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.pf1_and_pf2_and_tf1 + ", " + this.tf2), (boolean)FilterUtils.areDisjoint(this.pf1_and_pf2_and_tf1, this.tf2));
    }

    public void testAndOr() throws Exception {
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.pf1_and_tf1, this.pf1_AND_tf1_or_tf2));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.pf1_and_pf2_and_tf1, this.pf1_and_pf2_OR_tf1));
    }

    public void testParentAncestor() throws Exception {
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areProperSubset(this.parent_cf_ComponentFeature, this.ancestor_cf_ComponentFeature));
        FilterUtilsTest.assertTrue((!FilterUtils.areProperSubset(this.ancestor_cf_ComponentFeature, this.parent_cf_ComponentFeature) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.ancestor_cf_ComponentFeature, this.not_ancestor_cf_ComponentFeature));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(this.not_ancestor_cf_ComponentFeature, this.parent_cf_ComponentFeature));
    }

    public void testHasProperty() throws Exception {
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf1 + ", " + this.pf2), (!FilterUtils.areDisjoint(this.pf1, this.pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf2 + ", " + this.pf3), (!FilterUtils.areDisjoint(this.pf2, this.pf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf1 + ", " + this.pf3), (!FilterUtils.areDisjoint(this.pf1, this.pf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf1 + ", " + this.pf2), (!FilterUtils.areProperSubset(this.pf1, this.pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf1 + ", " + this.pf3), (!FilterUtils.areProperSubset(this.pf1, this.pf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf2 + ", " + this.pf3), (!FilterUtils.areProperSubset(this.pf2, this.pf3) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf1 + ", " + this.pf1), (boolean)FilterUtils.areProperSubset(this.pf1, this.pf1));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf2 + ", " + this.pf2), (boolean)FilterUtils.areProperSubset(this.pf2, this.pf2));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf3 + ", " + this.pf3), (boolean)FilterUtils.areProperSubset(this.pf3, this.pf3));
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf1 + ", " + this.pf1), (!FilterUtils.areDisjoint(this.pf1, this.pf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf2 + ", " + this.pf2), (!FilterUtils.areDisjoint(this.pf2, this.pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf3 + ", " + this.pf3), (!FilterUtils.areDisjoint(this.pf3, this.pf3) ? 1 : 0) != 0);
    }

    public void testByProperty() throws Exception {
        FilterUtilsTest.assertTrue((String)("are disjoint: " + this.pf4 + ", " + this.pf5), (boolean)FilterUtils.areDisjoint(this.pf4, this.pf5));
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf4 + ", " + this.pf6), (!FilterUtils.areDisjoint(this.pf4, this.pf6) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf5 + ", " + this.pf6), (!FilterUtils.areDisjoint(this.pf5, this.pf6) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf4 + ", " + this.pf5), (!FilterUtils.areProperSubset(this.pf4, this.pf5) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf4 + ", " + this.pf6), (!FilterUtils.areProperSubset(this.pf4, this.pf6) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf5 + ", " + this.pf6), (!FilterUtils.areProperSubset(this.pf5, this.pf6) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf4 + ", " + this.pf4), (boolean)FilterUtils.areProperSubset(this.pf4, this.pf4));
    }

    public void testHasByProperty() throws Exception {
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf1 + ", " + this.pf4), (!FilterUtils.areDisjoint(this.pf1, this.pf4) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf2 + ", " + this.pf4), (!FilterUtils.areDisjoint(this.pf2, this.pf4) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not disjoint: " + this.pf3 + ", " + this.pf4), (!FilterUtils.areDisjoint(this.pf3, this.pf4) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf1 + ", " + this.pf4), (!FilterUtils.areProperSubset(this.pf1, this.pf4) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf4 + ", " + this.pf1), (boolean)FilterUtils.areProperSubset(this.pf4, this.pf1));
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf5 + ", " + this.pf1), (boolean)FilterUtils.areProperSubset(this.pf5, this.pf1));
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf6 + ", " + this.pf1), (!FilterUtils.areProperSubset(this.pf6, this.pf1) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf2 + ", " + this.pf4), (!FilterUtils.areProperSubset(this.pf2, this.pf4) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf4 + ", " + this.pf2), (!FilterUtils.areProperSubset(this.pf4, this.pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("not subset: " + this.pf5 + ", " + this.pf2), (!FilterUtils.areProperSubset(this.pf5, this.pf2) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((String)("are subset: " + this.pf6 + ", " + this.pf2), (boolean)FilterUtils.areProperSubset(this.pf6, this.pf2));
    }

    public void testAndOptimizeAllNone() {
        this.optimizeExact(this.all_and_all, FilterUtils.all());
        this.optimizeExact(FilterUtils.and(this.all_and_all, this.all_and_all), FilterUtils.all());
        this.optimizeExact(this.all_and_none, FilterUtils.none());
        this.optimizeExact(FilterUtils.and(this.all_and_none, FilterUtils.all()), FilterUtils.none());
        this.optimizeExact(this.none_and_none, FilterUtils.none());
    }

    public void testOrOptimizeAllNone() {
        this.optimizeExact(this.all_or_all, FilterUtils.all());
        this.optimizeExact(FilterUtils.or(this.all_or_all, this.all_or_all), FilterUtils.all());
        this.optimizeExact(this.all_or_none, FilterUtils.all());
        this.optimizeExact(FilterUtils.or(this.all_or_none, FilterUtils.none()), FilterUtils.all());
        this.optimizeExact(this.none_or_none, FilterUtils.none());
    }

    public void testAndOrAllNone() {
        this.optimizeExact(FilterUtils.or(this.all_and_all, FilterUtils.all()), FilterUtils.all());
        this.optimizeExact(FilterUtils.or(this.all_and_none, FilterUtils.all()), FilterUtils.all());
        this.optimizeExact(FilterUtils.or(this.all_and_all, FilterUtils.none()), FilterUtils.all());
        this.optimizeExact(FilterUtils.or(this.all_and_none, FilterUtils.none()), FilterUtils.none());
        this.optimizeExact(FilterUtils.and(this.all_or_all, FilterUtils.all()), FilterUtils.all());
    }

    public void testUseCases() {
        FeatureFilter transcript = FilterUtils.byType("transcript");
        FeatureFilter exon = FilterUtils.byType("exon");
        FeatureFilter repeat = FilterUtils.byType("repeat");
        AnnotationType.Impl tsType = new AnnotationType.Impl();
        tsType.setConstraints("transcript.id", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        tsType.setDefaultConstraints(PropertyConstraint.NONE, CardinalityConstraint.NONE);
        FeatureFilter tsID = FilterUtils.byAnnotationType(tsType);
        AnnotationType.Impl exType = new AnnotationType.Impl();
        exType.setConstraints("id", new PropertyConstraint.ByClass(String.class), CardinalityConstraint.ONE);
        exType.setDefaultConstraints(PropertyConstraint.NONE, CardinalityConstraint.NONE);
        FeatureFilter exID = FilterUtils.byAnnotationType(exType);
        AnnotationType.Impl rpType = new AnnotationType.Impl();
        rpType.setConstraints("id", PropertyConstraint.ANY, CardinalityConstraint.ONE);
        rpType.setDefaultConstraints(PropertyConstraint.NONE, CardinalityConstraint.NONE);
        FeatureFilter repeatID = FilterUtils.byAnnotationType(rpType);
        FeatureFilter tsSchema = FilterUtils.and(transcript, tsID);
        FeatureFilter exSchema = FilterUtils.and(exon, exID);
        FeatureFilter reSchema = FilterUtils.and(repeat, repeatID);
        FeatureFilter dbFilter = FilterUtils.or(new FeatureFilter[]{tsSchema, exSchema, reSchema});
        FeatureFilter aTranscript = FilterUtils.byAnnotation("transcript.id", "ts:42");
        this.optimizeEquals(FilterUtils.and(tsSchema, aTranscript), FilterUtils.and(transcript, aTranscript));
        this.optimizeExact(FilterUtils.and(exSchema, aTranscript), FilterUtils.none());
        this.optimizeExact(FilterUtils.and(reSchema, aTranscript), FilterUtils.none());
        this.optimizeEquals(dbFilter, dbFilter);
        this.optimizeEquals(FilterUtils.and(dbFilter, aTranscript), FilterUtils.and(transcript, aTranscript));
    }

    public void testAndOrMethods() {
        this.checkEquals(FilterUtils.and(FilterUtils.and(this.tf1, this.tf2), this.tf3), FilterUtils.and(new FeatureFilter[]{this.tf1, this.tf2, this.tf3}));
        this.checkEquals(FilterUtils.and(this.tf1, FilterUtils.and(this.tf2, this.tf3)), FilterUtils.and(new FeatureFilter[]{this.tf1, this.tf2, this.tf3}));
        this.checkEquals(FilterUtils.or(FilterUtils.or(this.tf1, this.tf2), this.tf3), FilterUtils.or(new FeatureFilter[]{this.tf1, this.tf2, this.tf3}));
        this.checkEquals(FilterUtils.or(this.tf1, FilterUtils.or(this.tf2, this.tf3)), FilterUtils.or(new FeatureFilter[]{this.tf1, this.tf2, this.tf3}));
    }

    public void testAncestorDescendants() {
        FeatureFilter.ByType type_foo = new FeatureFilter.ByType("foo");
        FeatureFilter.ByType type_bar = new FeatureFilter.ByType("bar");
        FeatureFilter.ByAncestor test = new FeatureFilter.ByAncestor(new FeatureFilter.OnlyDescendants(type_foo));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(type_bar, test));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_foo, test) ? 1 : 0) != 0);
    }

    public void testOrAncestorDescendants() {
        FeatureFilter.ByType type_foo = new FeatureFilter.ByType("foo");
        FeatureFilter.ByType type_bar = new FeatureFilter.ByType("bar");
        FeatureFilter.ByAncestor test = new FeatureFilter.ByAncestor(new FeatureFilter.OnlyDescendants(type_foo));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(type_bar, test));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_foo, test) ? 1 : 0) != 0);
    }

    public void testAncestorLeafChildren() {
        FeatureFilter.ByType type_foo = new FeatureFilter.ByType("foo");
        FeatureFilter.ByType type_bar = new FeatureFilter.ByType("bar");
        FeatureFilter.ByAncestor test = new FeatureFilter.ByAncestor(new FeatureFilter.OnlyChildren(new FeatureFilter.And(type_foo, FeatureFilter.leaf)));
        FeatureFilter.ByAncestor test_nonleaf = new FeatureFilter.ByAncestor(new FeatureFilter.OnlyChildren(type_foo));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(type_bar, test));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_bar, test_nonleaf) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_foo, test) ? 1 : 0) != 0);
    }

    public void testAncestorComplexChildren() {
        FeatureFilter.ByType type_foo = new FeatureFilter.ByType("foo");
        FeatureFilter.ByType type_bar = new FeatureFilter.ByType("bar");
        FeatureFilter.ByType type_baz = new FeatureFilter.ByType("baz");
        FeatureFilter.ByAncestor test = new FeatureFilter.ByAncestor(new FeatureFilter.OnlyChildren(new FeatureFilter.And(type_foo, new FeatureFilter.OnlyChildren(new FeatureFilter.And(type_baz, FeatureFilter.leaf)))));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(type_bar, test));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_foo, test) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_baz, test) ? 1 : 0) != 0);
    }

    public void testParentChildren() {
        FeatureFilter.ByType type_foo = new FeatureFilter.ByType("foo");
        FeatureFilter.ByType type_bar = new FeatureFilter.ByType("bar");
        FeatureFilter.ByType type_baz = new FeatureFilter.ByType("baz");
        FeatureFilter.ByParent test = new FeatureFilter.ByParent(new FeatureFilter.OnlyChildren(new FeatureFilter.And(type_foo, new FeatureFilter.OnlyChildren(new FeatureFilter.And(type_baz, FeatureFilter.leaf)))));
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(type_bar, test));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(type_foo, test) ? 1 : 0) != 0);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(type_baz, test));
    }

    public void testDisjointAnnotationTypes() {
        AnnotationType.Impl atype = new AnnotationType.Impl();
        atype.setDefaultConstraints(PropertyConstraint.NONE, CardinalityConstraint.ZERO);
        atype.setConstraints("foo", PropertyConstraint.ANY, CardinalityConstraint.ONE);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(new FeatureFilter.ByAnnotationType(atype), new FeatureFilter.ByAnnotation("bar", "some_value")));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(new FeatureFilter.ByAnnotationType(atype), new FeatureFilter.ByAnnotation("foo", "some_value")) ? 1 : 0) != 0);
    }

    public void testDisjointAnnotationTypesContains() {
        AnnotationType.Impl atype = new AnnotationType.Impl();
        atype.setDefaultConstraints(PropertyConstraint.NONE, CardinalityConstraint.ZERO);
        atype.setConstraints("foo", PropertyConstraint.ANY, CardinalityConstraint.ONE);
        FilterUtilsTest.assertTrue((boolean)FilterUtils.areDisjoint(new FeatureFilter.ByAnnotationType(atype), new FeatureFilter.AnnotationContains("bar", "some_value")));
        FilterUtilsTest.assertTrue((!FilterUtils.areDisjoint(new FeatureFilter.ByAnnotationType(atype), new FeatureFilter.AnnotationContains("foo", "some_value")) ? 1 : 0) != 0);
    }

    private void optimizeExact(FeatureFilter raw, FeatureFilter target) {
        FeatureFilter result = FilterUtils.optimize(raw);
        FilterUtilsTest.assertTrue((String)("optimize: " + raw + " should be " + target + " but is " + result), (result == target ? 1 : 0) != 0);
    }

    private void optimizeEquals(FeatureFilter raw, FeatureFilter target) {
        FeatureFilter result = FilterUtils.optimize(raw);
        FilterUtilsTest.assertTrue((String)("optimize: " + raw + " should be " + target + " but is " + result), (boolean)result.equals(target));
    }

    private void checkEquals(FeatureFilter a, FeatureFilter b) {
        FilterUtilsTest.assertTrue((String)("equal: " + a + ", " + b), (boolean)a.equals(b));
    }
}

