/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleComponentFeature;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.impl.NewAssembledSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class NewSimpleAssembly
extends AbstractChangeable
implements Sequence,
RealizingFeatureHolder {
    private String name;
    private String uri;
    private Annotation annotation = new SimpleAnnotation();
    private SimpleFeatureHolder features;
    private NewAssembledSymbolList assembly;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;
    protected transient ChangeForwarder annotationForwarder;

    public NewSimpleAssembly(int length, String name, String uri) {
        this.assembly = new NewAssembledSymbolList();
        this.features = new SimpleFeatureHolder();
        this.name = name;
        this.uri = uri;
        this.assembly.setLength(length);
    }

    public NewSimpleAssembly(String name, String uri) {
        this.assembly = new NewAssembledSymbolList();
        this.features = new SimpleFeatureHolder();
        this.name = name;
        this.uri = uri;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.assembly.getAlphabet();
    }

    @Override
    public int length() {
        return this.assembly.length();
    }

    @Override
    public Symbol symbolAt(int pos) {
        return this.assembly.symbolAt(pos);
    }

    @Override
    public SymbolList subList(int start, int end) {
        return this.assembly.subList(start, end);
    }

    @Override
    public String seqString() {
        return this.assembly.seqString();
    }

    @Override
    public String subStr(int start, int end) {
        return this.assembly.subStr(start, end);
    }

    @Override
    public Iterator iterator() {
        return this.assembly.iterator();
    }

    @Override
    public List toList() {
        return this.assembly.toList();
    }

    @Override
    public void edit(Edit e) throws IllegalAlphabetException, ChangeVetoException {
        this.assembly.edit(e);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURN() {
        return this.uri;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Iterator features() {
        return this.features.features();
    }

    @Override
    public int countFeatures() {
        return this.features.countFeatures();
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.features.filter(ff, recurse);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.features.filter(ff);
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.features.containsFeature(f);
    }

    @Override
    public Feature createFeature(Feature.Template temp) throws BioException, ChangeVetoException {
        if (temp.location.getMin() < 1) {
            throw new BioException("Coordinates out of range");
        }
        Feature f = this.realizeFeature(this, temp);
        this.features.addFeature(f);
        if (f instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)f;
            Location loc = cf.getLocation();
            if (loc.getMax() > this.assembly.length()) {
                this.assembly.setLength(loc.getMax());
            }
            this.assembly.putComponent(cf);
        }
        return f;
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException {
        if (f instanceof ComponentFeature) {
            this.assembly.removeComponent((ComponentFeature)f);
        }
        this.features.removeFeature(f);
    }

    @Override
    public Feature realizeFeature(FeatureHolder fh, Feature.Template temp) throws BioException {
        if (temp instanceof ComponentFeature.Template) {
            if (fh != this) {
                throw new BioException("ComponentFeatures can only be attached directly to SimpleAssembly objects");
            }
            ComponentFeature.Template cft = (ComponentFeature.Template)temp;
            return new SimpleComponentFeature(this, cft);
        }
        FeatureHolder gopher = fh;
        while (gopher instanceof Feature) {
            if (gopher instanceof ComponentFeature) {
                throw new BioException("Cannot [currently] realize features on components of SimpleAssemblies");
            }
            gopher = ((Feature)gopher).getParent();
        }
        return this.featureRealizer.realizeFeature(this, fh, temp);
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct == null || ct == Annotatable.ANNOTATION)) {
            this.annotationForwarder = new ChangeForwarder.Retyper(this, cs, Annotation.PROPERTY);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        return cs;
    }

    @Override
    public FeatureFilter getSchema() {
        return FeatureFilter.top_level;
    }
}

