/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.NewSimpleAssembly;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class NewSimpleAssemblyTest
extends TestCase {
    protected Sequence fragment1;
    protected Sequence fragment2;
    protected Sequence fragment3;
    protected Sequence fragment4;
    protected Sequence fragment5;
    protected Sequence fragment6;
    protected Sequence assembly;

    public NewSimpleAssemblyTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fragment1 = new SimpleSequence(DNATools.createDNA("aacgta"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        this.fragment2 = new SimpleSequence(DNATools.createDNA("ttgatgc"), "fragment2", "fragment2", Annotation.EMPTY_ANNOTATION);
        this.fragment3 = new SimpleSequence(DNATools.createDNA("aagctt"), "fragment3", "fragment3", Annotation.EMPTY_ANNOTATION);
        this.fragment4 = new SimpleSequence(DNATools.createDNA("ttagat"), "fragment4", "fragment4", Annotation.EMPTY_ANNOTATION);
        this.fragment5 = new SimpleSequence(DNATools.createDNA("ggatcc"), "fragment5", "fragment5", Annotation.EMPTY_ANNOTATION);
        this.fragment6 = new SimpleSequence(DNATools.createDNA("atctgg"), "fragment6", "fragment6", Annotation.EMPTY_ANNOTATION);
        StrandedFeature.Template sft = new StrandedFeature.Template();
        sft.type = "project_test";
        sft.source = "test";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.strand = StrandedFeature.NEGATIVE;
        sft.location = new RangeLocation(1, 3);
        this.fragment2.createFeature(sft);
        this.assembly = new NewSimpleAssembly(31, "test", "test");
        ComponentFeature.Template templ = new ComponentFeature.Template();
        templ.type = "component";
        templ.source = "test";
        templ.annotation = Annotation.EMPTY_ANNOTATION;
        templ.strand = StrandedFeature.POSITIVE;
        templ.location = new RangeLocation(1, 4);
        templ.componentSequence = this.fragment1;
        templ.componentLocation = new RangeLocation(2, 5);
        this.assembly.createFeature(templ);
        templ.strand = StrandedFeature.NEGATIVE;
        templ.location = new RangeLocation(6, 12);
        templ.componentSequence = this.fragment2;
        templ.componentLocation = new RangeLocation(1, this.fragment2.length());
        this.assembly.createFeature(templ);
        templ.strand = StrandedFeature.POSITIVE;
        templ.location = new RangeLocation(14, 19);
        templ.componentSequence = this.fragment3;
        templ.componentLocation = new RangeLocation(1, this.fragment3.length());
        this.assembly.createFeature(templ);
        templ.strand = StrandedFeature.POSITIVE;
        templ.location = new RangeLocation(18, 23);
        templ.componentSequence = this.fragment4;
        templ.componentLocation = new RangeLocation(1, this.fragment4.length());
        this.assembly.createFeature(templ);
        templ.strand = StrandedFeature.POSITIVE;
        templ.location = new RangeLocation(26, 31);
        templ.componentSequence = this.fragment5;
        templ.componentLocation = new RangeLocation(1, this.fragment5.length());
        this.assembly.createFeature(templ);
        templ.strand = StrandedFeature.POSITIVE;
        templ.location = new RangeLocation(22, 27);
        templ.componentSequence = this.fragment6;
        templ.componentLocation = new RangeLocation(1, this.fragment6.length());
        this.assembly.createFeature(templ);
    }

    public void testAssembledSymbols() throws Exception {
        NewSimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly, DNATools.createDNA("acgtngcatcaanaagcttagatctggatcc")));
        NewSimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(1, 4), DNATools.createDNA("acgt")));
        NewSimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(1, 5), DNATools.createDNA("acgtn")));
        NewSimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(5, 5), DNATools.createDNA("n")));
        NewSimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(11, 12), DNATools.createDNA("aa")));
    }

    public void testProjectedFeatures() throws Exception {
        FeatureHolder f = this.assembly.filter(new FeatureFilter.ByType("project_test"), true);
        NewSimpleAssemblyTest.assertEquals((int)f.countFeatures(), (int)1);
        Feature pf = (Feature)f.features().next();
        Location pfl = pf.getLocation();
        NewSimpleAssemblyTest.assertEquals((int)pfl.getMin(), (int)10);
        NewSimpleAssemblyTest.assertEquals((int)pfl.getMax(), (int)12);
    }

    private boolean compareSymbolList(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }
}

