/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import junit.framework.TestCase;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SymbolList;

public class ProteinToolsTest
extends TestCase {
    protected SymbolTokenization tokens;
    protected FiniteAlphabet proteinAlpha;
    protected FiniteAlphabet proteinTAlpha;

    public ProteinToolsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tokens = AlphabetManager.alphabetForName("PROTEIN-TERM").getTokenization("token");
        this.proteinAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
        this.proteinTAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN-TERM");
    }

    public void testGetAlpha() {
        ProteinToolsTest.assertEquals((Object)this.proteinAlpha, (Object)ProteinTools.getAlphabet());
        ProteinToolsTest.assertEquals((Object)this.proteinTAlpha, (Object)ProteinTools.getTAlphabet());
        ProteinToolsTest.assertTrue((this.proteinAlpha == ProteinTools.getAlphabet() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((this.proteinTAlpha == ProteinTools.getTAlphabet() ? 1 : 0) != 0);
    }

    public void testCreateProtein() throws Exception {
        SymbolList aa = ProteinTools.createProtein("arndcqeghilkmfpstwyvuo*x");
        ProteinToolsTest.assertTrue((aa.symbolAt(1) == ProteinTools.a() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(1) == ProteinTools.ala() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(2) == ProteinTools.r() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(2) == ProteinTools.arg() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(3) == ProteinTools.n() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(3) == ProteinTools.asn() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(4) == ProteinTools.d() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(4) == ProteinTools.asp() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(5) == ProteinTools.c() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(5) == ProteinTools.cys() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(6) == ProteinTools.q() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(6) == ProteinTools.gln() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(7) == ProteinTools.e() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(7) == ProteinTools.glu() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(8) == ProteinTools.g() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(8) == ProteinTools.gly() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(9) == ProteinTools.h() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(9) == ProteinTools.his() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(10) == ProteinTools.i() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(10) == ProteinTools.ile() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(11) == ProteinTools.l() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(11) == ProteinTools.leu() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(12) == ProteinTools.k() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(12) == ProteinTools.lys() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(13) == ProteinTools.m() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(13) == ProteinTools.met() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(14) == ProteinTools.f() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(14) == ProteinTools.phe() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(15) == ProteinTools.p() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(15) == ProteinTools.pro() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(16) == ProteinTools.s() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(16) == ProteinTools.ser() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(17) == ProteinTools.t() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(17) == ProteinTools.thr() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(18) == ProteinTools.w() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(18) == ProteinTools.trp() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(19) == ProteinTools.y() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(19) == ProteinTools.tyr() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(20) == ProteinTools.v() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(20) == ProteinTools.val() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(21) == ProteinTools.u() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(21) == ProteinTools.sec() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(22) == ProteinTools.o() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(22) == ProteinTools.pyl() ? 1 : 0) != 0);
        ProteinToolsTest.assertTrue((aa.symbolAt(23) == ProteinTools.ter() ? 1 : 0) != 0);
    }
}

