/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ManyToOneTranslationTable;
import org.biojava.bio.symbol.SimpleGeneticCodeTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class RNAToolsTest
extends TestCase {
    public RNAToolsTest(String name) {
        super(name);
    }

    public void testSymbols() throws IllegalSymbolException {
        RNAToolsTest.assertEquals((String)"a", (String)this.getRNATokenization().tokenizeSymbol(RNATools.a()));
        RNAToolsTest.assertEquals((String)"c", (String)this.getRNATokenization().tokenizeSymbol(RNATools.c()));
        RNAToolsTest.assertEquals((String)"g", (String)this.getRNATokenization().tokenizeSymbol(RNATools.g()));
        RNAToolsTest.assertEquals((String)"u", (String)this.getRNATokenization().tokenizeSymbol(RNATools.u()));
    }

    public void testCreateRNASequenceGetName() throws IllegalSymbolException {
        String sequenceName = "the name";
        Sequence sequence = RNATools.createRNASequence("uacg-", sequenceName);
        RNAToolsTest.assertEquals((String)sequenceName, (String)sequence.getName());
    }

    public void testCreateRNASequenceAnnotationIsEmpty() throws IllegalSymbolException {
        Sequence sequence = RNATools.createRNASequence("uacg-", "the name");
        RNAToolsTest.assertTrue((boolean)sequence.getAnnotation().asMap().isEmpty());
    }

    public void testCreateRNASequenceURNIsBlank() throws IllegalSymbolException {
        Sequence sequence = RNATools.createRNASequence("uacg-", "the name");
        RNAToolsTest.assertEquals((String)"", (String)sequence.getURN());
    }

    public void testCreateRNASequenceSequenceCorrect() throws IllegalSymbolException {
        String sequenceString = "uacg-";
        RNAToolsTest.assertEquals((String)sequenceString, (String)((SimpleSequence)RNATools.createRNASequence(sequenceString, "the name")).seqString());
    }

    public void testGetCodonAlphabet() {
        List<FiniteAlphabet> threeCopiesOfRNAAlphabet = Collections.nCopies(3, RNATools.getRNA());
        RNAToolsTest.assertEquals((Object)RNATools.getCodonAlphabet(), (Object)AlphabetManager.getCrossProductAlphabet(threeCopiesOfRNAAlphabet));
    }

    public void testCreateRNA() throws IllegalAlphabetException, IllegalSymbolException {
        RNAToolsTest.assertEquals((String)"uacg-", (String)this.getRNATokenization().tokenizeSymbolList(RNATools.createRNA("uacg-")));
    }

    public void testComplementA() throws IllegalSymbolException {
        this.assertEquals(RNATools.u(), RNATools.complement(RNATools.a()));
    }

    public void testComplementC() throws IllegalSymbolException {
        this.assertEquals(RNATools.g(), RNATools.complement(RNATools.c()));
    }

    public void testComplementG() throws IllegalSymbolException {
        this.assertEquals(RNATools.c(), RNATools.complement(RNATools.g()));
    }

    public void testComplementU() throws IllegalSymbolException {
        this.assertEquals(RNATools.a(), RNATools.complement(RNATools.u()));
    }

    public void testComplementSymbolFromAnotherAlphabet() {
        try {
            RNATools.complement(DNATools.t());
            RNAToolsTest.fail((String)"Should have thrown an IllegalSymbolException");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            // empty catch block
        }
    }

    public void testComplementBadSymbol() throws IllegalSymbolException {
        try {
            RNATools.complement(this.createBadSymbol());
            RNAToolsTest.fail((String)"Should have thrown a BioError");
        }
        catch (BioError bioError) {
            // empty catch block
        }
    }

    public void testComplementList() throws IllegalAlphabetException, IllegalSymbolException {
        this.assertEquals(RNATools.createRNA("augc"), RNATools.complement(RNATools.createRNA("uacg")));
    }

    public void testReverseComplement() throws IllegalAlphabetException, IllegalSymbolException {
        this.assertEquals(RNATools.createRNA("cgua"), RNATools.reverseComplement(RNATools.createRNA("uacg")));
    }

    public void testTranscribe() throws IllegalAlphabetException, IllegalSymbolException {
        this.assertEquals(RNATools.createRNA("gcau"), RNATools.transcribe(DNATools.createDNA("gcat")));
    }

    public void testTranslate() throws IllegalAlphabetException, IllegalSymbolException {
        this.assertEquals(ProteinTools.createProtein("FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG"), RNATools.translate(RNATools.createRNA("uuuuucuuauugucuuccucaucguauuacuaauaguguugcugauggcuucuccuacugccucccccaccgcaucaccaacagcgucgccgacggauuaucauaaugacuaccacaacgaauaacaaaaagaguagcagaaggguugucguaguggcugccgcagcggaugacgaagaggguggcggaggg")));
    }

    public void testForSymbolA() throws IllegalSymbolException {
        this.assertEquals(RNATools.a(), RNATools.forSymbol('a'));
    }

    public void testForSymbolC() throws IllegalSymbolException {
        this.assertEquals(RNATools.c(), RNATools.forSymbol('c'));
    }

    public void testForSymbolG() throws IllegalSymbolException {
        this.assertEquals(RNATools.g(), RNATools.forSymbol('g'));
    }

    public void testForSymbolU() throws IllegalSymbolException {
        this.assertEquals(RNATools.u(), RNATools.forSymbol('u'));
    }

    public void testForSymbolWithBadChar() {
        try {
            RNATools.forSymbol('$');
            RNAToolsTest.fail((String)"Should have thrown an IllegalSymbolException");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            // empty catch block
        }
    }

    public void testForIndex0() throws IllegalSymbolException {
        this.assertEquals(RNATools.a(), RNATools.forIndex(0));
    }

    public void testForIndex1() throws IllegalSymbolException {
        this.assertEquals(RNATools.g(), RNATools.forIndex(1));
    }

    public void testForIndex2() throws IllegalSymbolException {
        this.assertEquals(RNATools.c(), RNATools.forIndex(2));
    }

    public void testForIndex3() throws IllegalSymbolException {
        this.assertEquals(RNATools.u(), RNATools.forIndex(3));
    }

    public void testForIndexWithBadIndex() {
        try {
            RNATools.forIndex(4);
            RNAToolsTest.fail((String)"Should have thrown an IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testIndexA() throws IllegalSymbolException {
        RNAToolsTest.assertEquals((int)0, (int)RNATools.index(RNATools.a()));
    }

    public void testIndexG() throws IllegalSymbolException {
        RNAToolsTest.assertEquals((int)1, (int)RNATools.index(RNATools.g()));
    }

    public void testIndexC() throws IllegalSymbolException {
        RNAToolsTest.assertEquals((int)2, (int)RNATools.index(RNATools.c()));
    }

    public void testIndexU() throws IllegalSymbolException {
        RNAToolsTest.assertEquals((int)3, (int)RNATools.index(RNATools.u()));
    }

    public void testIndexSymbolFromAnotherAlphabet() {
        try {
            RNATools.index(DNATools.t());
            RNAToolsTest.fail((String)"Should have thrown an IllegalSymbolException");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            // empty catch block
        }
    }

    public void testIndexBadSymbol() {
        try {
            RNATools.index(this.createBadSymbol());
            RNAToolsTest.fail((String)"Should have thrown an IllegalSymbolException");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            // empty catch block
        }
    }

    public void testGeneticCode() {
        try {
            ManyToOneTranslationTable geneticCode = RNATools.getGeneticCode("UNIVERSAL");
            RNAToolsTest.assertNotNull((Object)geneticCode);
            FiniteAlphabet aaAlfa = ProteinTools.getTAlphabet();
            RNAToolsTest.assertNotNull((Object)aaAlfa);
            Iterator aaI = aaAlfa.iterator();
            while (aaI.hasNext()) {
                Symbol residue = (Symbol)aaI.next();
                Set codons = geneticCode.untranslate(residue);
                RNAToolsTest.assertNotNull((Object)codons);
                for (Symbol codon : codons) {
                    Symbol xlatedResidue = geneticCode.translate(codon);
                    this.assertEquals(residue, xlatedResidue);
                }
            }
            Set tableNames = RNATools.getGeneticCodeNames();
            RNAToolsTest.assertEquals((int)17, (int)tableNames.size());
            ManyToOneTranslationTable geneticCode1 = RNATools.getGeneticCode("UNIVERSAL");
            ManyToOneTranslationTable geneticCode2 = RNATools.getGeneticCode(1);
            RNAToolsTest.assertEquals((Object)geneticCode1, (Object)geneticCode2);
            String description = ((SimpleGeneticCodeTable)geneticCode2).getDescription();
            RNAToolsTest.assertEquals((String)description, (String)"Standard Code");
            int number = ((SimpleGeneticCodeTable)geneticCode2).getTableNumber();
            RNAToolsTest.assertEquals((int)1, (int)number);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            // empty catch block
        }
    }

    public void assertEquals(Symbol expected, Symbol actual) throws IllegalSymbolException {
        RNAToolsTest.assertEquals((String)this.getRNATokenization().tokenizeSymbol(expected), (String)this.getRNATokenization().tokenizeSymbol(actual));
    }

    public void assertEquals(SymbolList expected, SymbolList actual) throws IllegalAlphabetException, IllegalSymbolException {
        try {
            SymbolTokenization expectedTokenization = expected.getAlphabet().getTokenization("token");
            SymbolTokenization actualTokenization = actual.getAlphabet().getTokenization("token");
            RNAToolsTest.assertEquals((String)expectedTokenization.tokenizeSymbolList(expected), (String)actualTokenization.tokenizeSymbolList(actual));
        }
        catch (BioException e) {
            throw new BioError(e);
        }
    }

    private SymbolTokenization getRNATokenization() {
        try {
            return RNATools.getRNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError(e);
        }
    }

    private Symbol createBadSymbol() {
        return new Symbol(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public Alphabet getMatches() {
                return new FiniteAlphabet(){

                    @Override
                    public int size() {
                        return 0;
                    }

                    @Override
                    public String getName() {
                        return null;
                    }

                    @Override
                    public Annotation getAnnotation() {
                        return null;
                    }

                    @Override
                    public void addChangeListener(ChangeListener cl) {
                    }

                    @Override
                    public Iterator iterator() {
                        return null;
                    }

                    @Override
                    public List getAlphabets() {
                        return null;
                    }

                    @Override
                    public void addChangeListener(ChangeListener cl, ChangeType ct) {
                    }

                    @Override
                    public void addSymbol(Symbol s) throws IllegalSymbolException, ChangeVetoException {
                    }

                    @Override
                    public Symbol getSymbol(List rl) throws IllegalSymbolException {
                        return null;
                    }

                    @Override
                    public void removeChangeListener(ChangeListener cl) {
                    }

                    @Override
                    public void removeSymbol(Symbol s) throws IllegalSymbolException, ChangeVetoException {
                    }

                    @Override
                    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
                        return null;
                    }

                    @Override
                    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
                    }

                    @Override
                    public Symbol getGapSymbol() {
                        return null;
                    }

                    @Override
                    public boolean isUnchanging(ChangeType ct) {
                        return false;
                    }

                    @Override
                    public boolean contains(Symbol s) {
                        return false;
                    }

                    @Override
                    public void validate(Symbol s) throws IllegalSymbolException {
                    }

                    @Override
                    public SymbolTokenization getTokenization(String name) throws BioException {
                        return null;
                    }
                };
            }

            @Override
            public Annotation getAnnotation() {
                return null;
            }

            @Override
            public void addChangeListener(ChangeListener cl) {
            }

            @Override
            public void addChangeListener(ChangeListener cl, ChangeType ct) {
            }

            @Override
            public void removeChangeListener(ChangeListener cl) {
            }

            @Override
            public void removeChangeListener(ChangeListener cl, ChangeType ct) {
            }

            @Override
            public boolean isUnchanging(ChangeType ct) {
                return false;
            }
        };
    }
}

