/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class SimpleAssemblyTest
extends TestCase {
    protected Sequence fragment1;
    protected Sequence fragment2;
    protected Sequence assembly;

    public SimpleAssemblyTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fragment1 = new SimpleSequence(DNATools.createDNA("aacgta"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        this.fragment2 = new SimpleSequence(DNATools.createDNA("ttgatgc"), "fragment2", "fragment2", Annotation.EMPTY_ANNOTATION);
        StrandedFeature.Template sft = new StrandedFeature.Template();
        sft.type = "project_test";
        sft.source = "test";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.strand = StrandedFeature.NEGATIVE;
        sft.location = new RangeLocation(1, 3);
        this.fragment2.createFeature(sft);
        this.assembly = new SimpleAssembly(12, "test", "test");
        ComponentFeature.Template templ = new ComponentFeature.Template();
        templ.type = "component";
        templ.source = "test";
        templ.annotation = Annotation.EMPTY_ANNOTATION;
        templ.strand = StrandedFeature.POSITIVE;
        templ.location = new RangeLocation(1, 4);
        templ.componentSequence = this.fragment1;
        templ.componentLocation = new RangeLocation(2, 5);
        this.assembly.createFeature(templ);
        templ.strand = StrandedFeature.NEGATIVE;
        templ.location = new RangeLocation(6, 12);
        templ.componentSequence = this.fragment2;
        templ.componentLocation = new RangeLocation(1, this.fragment2.length());
        this.assembly.createFeature(templ);
    }

    public void testAssembledSymbols() throws Exception {
        SimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly, DNATools.createDNA("acgtngcatcaa")));
        SimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(1, 4), DNATools.createDNA("acgt")));
        SimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(1, 5), DNATools.createDNA("acgtn")));
        SimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(5, 5), DNATools.createDNA("n")));
        SimpleAssemblyTest.assertTrue((boolean)this.compareSymbolList(this.assembly.subList(11, 12), DNATools.createDNA("aa")));
    }

    public void testProjectedFeatures() throws Exception {
        FeatureHolder f = this.assembly.filter(new FeatureFilter.ByType("project_test"), true);
        SimpleAssemblyTest.assertEquals((int)f.countFeatures(), (int)1);
        Feature pf = (Feature)f.features().next();
        Location pfl = pf.getLocation();
        SimpleAssemblyTest.assertEquals((int)pfl.getMin(), (int)10);
        SimpleAssemblyTest.assertEquals((int)pfl.getMax(), (int)12);
    }

    private boolean compareSymbolList(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }
}

