/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.LocationTools;

public abstract class AbstractSequenceDBTest
extends TestCase {
    protected SequenceDB mSequenceDB = null;

    public AbstractSequenceDBTest(String name) {
        super(name);
    }

    protected abstract SequenceDB getSequenceDB() throws Exception;

    public void setUp() throws Exception {
        this.mSequenceDB = this.getSequenceDB();
    }

    public void tearDown() throws Exception {
        this.mSequenceDB = null;
    }

    public void testAddFeature() throws Exception {
        String name = "dna_1";
        AbstractSequenceDBTest.assertTrue((!this.mSequenceDB.ids().contains(name) ? 1 : 0) != 0);
        this.mSequenceDB.addSequence(DNATools.createDNASequence("atgctgatgatgatg", name));
        AbstractSequenceDBTest.assertTrue((boolean)this.mSequenceDB.ids().contains(name));
        Sequence seq = this.mSequenceDB.getSequence(name);
        Feature.Template template = new Feature.Template();
        template.annotation = new SimpleAnnotation();
        template.location = LocationTools.makeLocation(10, 15);
        template.type = "noTS";
        template.source = "asource";
        seq.createFeature(template);
        AbstractSequenceDBTest.assertTrue((seq.countFeatures() == 1 ? 1 : 0) != 0);
    }

    public void testAddRemoveSequence() throws Exception {
        String name = "dna_1";
        AbstractSequenceDBTest.assertTrue((!this.mSequenceDB.ids().contains(name) ? 1 : 0) != 0);
        this.mSequenceDB.addSequence(DNATools.createDNASequence("atgctgatgatgatg", name));
        AbstractSequenceDBTest.assertTrue((boolean)this.mSequenceDB.ids().contains(name));
        Sequence seq = this.mSequenceDB.getSequence(name);
        seq = seq == null ? null : seq;
        this.mSequenceDB.removeSequence(name);
        AbstractSequenceDBTest.assertTrue((!this.mSequenceDB.ids().contains(name) ? 1 : 0) != 0);
    }

    public void testEditFeatures() throws Exception {
        String name = "dna_1";
        Sequence seq = DNATools.createDNASequence("atgctgatgatgatg", name);
        AbstractSequenceDBTest.assertTrue((!this.mSequenceDB.ids().contains(name) ? 1 : 0) != 0);
        this.mSequenceDB.addSequence(seq);
        AbstractSequenceDBTest.assertTrue((boolean)this.mSequenceDB.ids().contains(name));
        seq = this.mSequenceDB.getSequence(name);
        String sourceType = "asource";
        String annoTag = "anno";
        String annoVal = "123456";
        String anno2Tag = "blah";
        String anno2Val = "blahblah";
        Feature.Template template = new Feature.Template();
        template.annotation = new SimpleAnnotation();
        template.location = LocationTools.makeLocation(10, 15);
        template.type = "noANNO";
        template.source = sourceType;
        Feature noANNO = seq.createFeature(template);
        AbstractSequenceDBTest.assertTrue((!noANNO.getAnnotation().containsProperty(annoTag) ? 1 : 0) != 0);
        AbstractSequenceDBTest.assertTrue((seq.countFeatures() == 1 ? 1 : 0) != 0);
        template.type = "yesANNO";
        template.annotation.setProperty(annoTag, annoVal);
        Feature yesANNO = seq.createFeature(template);
        AbstractSequenceDBTest.assertTrue((boolean)yesANNO.getAnnotation().containsProperty(annoTag));
        AbstractSequenceDBTest.assertTrue((String)"createFeature should copy rather than referencing annotation.", (!noANNO.getAnnotation().containsProperty(annoTag) ? 1 : 0) != 0);
        AbstractSequenceDBTest.assertTrue((seq.countFeatures() == 2 ? 1 : 0) != 0);
        Iterator i = seq.features();
        AbstractSequenceDBTest.assertTrue((boolean)i.hasNext());
        Feature feature = (Feature)i.next();
        boolean yesFound = feature.getAnnotation().containsProperty(annoTag);
        if (yesFound) {
            AbstractSequenceDBTest.assertTrue((boolean)feature.getType().equals("yesANNO"));
        } else {
            AbstractSequenceDBTest.assertTrue((boolean)feature.getType().equals("noANNO"));
        }
        AbstractSequenceDBTest.assertTrue((boolean)i.hasNext());
        feature = (Feature)i.next();
        if (yesFound) {
            AbstractSequenceDBTest.assertTrue((boolean)feature.getType().equals("noANNO"));
            AbstractSequenceDBTest.assertTrue((!feature.getAnnotation().containsProperty(annoTag) ? 1 : 0) != 0);
        } else {
            AbstractSequenceDBTest.assertTrue((boolean)feature.getType().equals("yesANNO"));
            AbstractSequenceDBTest.assertTrue((boolean)feature.getAnnotation().containsProperty(annoTag));
        }
        AbstractSequenceDBTest.assertTrue((!i.hasNext() ? 1 : 0) != 0);
        FeatureHolder fh = seq.filter(new FeatureFilter.And(new FeatureFilter.BySource(sourceType), new FeatureFilter.Not(new FeatureFilter.ByAnnotation(annoTag, annoVal))));
        i = fh.features();
        AbstractSequenceDBTest.assertTrue((boolean)i.hasNext());
        feature = (Feature)i.next();
        AbstractSequenceDBTest.assertTrue((!feature.getAnnotation().containsProperty(annoTag) ? 1 : 0) != 0);
        seq.removeFeature(feature);
        i = seq.features();
        AbstractSequenceDBTest.assertTrue((boolean)i.hasNext());
        feature = (Feature)i.next();
        AbstractSequenceDBTest.assertTrue((boolean)feature.getAnnotation().containsProperty(annoTag));
        feature.getAnnotation().setProperty(anno2Tag, anno2Val);
        feature.getAnnotation().removeProperty(annoTag);
        AbstractSequenceDBTest.assertTrue((!feature.getAnnotation().containsProperty(annoTag) ? 1 : 0) != 0);
    }
}

