/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.EmblCDROMIndexStore;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.IndexedSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;

public class EmblCDROMIndexStoreTest
extends TestCase {
    protected SequenceFormat format;
    protected Alphabet alpha;
    protected SymbolTokenization parser;
    protected SequenceBuilderFactory factory;
    protected SequenceDB sequenceDB;
    protected IndexStore emblCDIndexStore;

    public EmblCDROMIndexStoreTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        URL divURL = EmblCDROMIndexStoreTest.class.getResource("emblcd/division.lkp");
        URL entURL = EmblCDROMIndexStoreTest.class.getResource("emblcd/entrynam.idx");
        File divisionLkp = new File(divURL.getFile());
        File entryNamIdx = new File(entURL.getFile());
        this.format = new FastaFormat();
        this.alpha = ProteinTools.getAlphabet();
        this.parser = this.alpha.getTokenization("token");
        this.factory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        this.emblCDIndexStore = new EmblCDROMIndexStore(divisionLkp, entryNamIdx, this.format, this.factory, this.parser);
        ((EmblCDROMIndexStore)this.emblCDIndexStore).setPathPrefix(entryNamIdx.getParentFile().getAbsoluteFile());
        this.sequenceDB = new IndexedSequenceDB(this.emblCDIndexStore);
    }

    protected void tearDown() throws Exception {
        ((EmblCDROMIndexStore)this.emblCDIndexStore).close();
    }

    public void testCommit() {
        try {
            this.emblCDIndexStore.commit();
        }
        catch (BioException be) {
            return;
        }
        EmblCDROMIndexStoreTest.fail((String)"Expected BioException");
    }

    public void testFetch() throws Exception {
        Index i1 = this.emblCDIndexStore.fetch("NMA0007");
        Index i2 = this.emblCDIndexStore.fetch("NMA0020");
        Index i3 = this.emblCDIndexStore.fetch("NMA0030");
        EmblCDROMIndexStoreTest.assertEquals((long)1811L, (long)i1.getStart());
        EmblCDROMIndexStoreTest.assertEquals((String)"protDB1.aa", (String)i1.getFile().getName());
        EmblCDROMIndexStoreTest.assertEquals((long)2379L, (long)i2.getStart());
        EmblCDROMIndexStoreTest.assertEquals((String)"protDB2.aa", (String)i2.getFile().getName());
        EmblCDROMIndexStoreTest.assertEquals((long)2510L, (long)i3.getStart());
        EmblCDROMIndexStoreTest.assertEquals((String)"protDB3.aa", (String)i3.getFile().getName());
        Sequence seq = this.sequenceDB.getSequence("NMA0007");
        EmblCDROMIndexStoreTest.assertEquals((String)"NMA0007", (String)seq.getName());
        EmblCDROMIndexStoreTest.assertEquals((int)235, (int)seq.length());
        seq = this.sequenceDB.getSequence("NMA0020");
        EmblCDROMIndexStoreTest.assertEquals((String)"NMA0020", (String)seq.getName());
        EmblCDROMIndexStoreTest.assertEquals((int)494, (int)seq.length());
        seq = this.sequenceDB.getSequence("NMA0030");
        EmblCDROMIndexStoreTest.assertEquals((String)"NMA0030", (String)seq.getName());
        EmblCDROMIndexStoreTest.assertEquals((int)245, (int)seq.length());
    }

    public void testIllegalIDFetch() throws BioException {
        try {
            Index i = this.emblCDIndexStore.fetch("xxxxx");
            i = i == null ? null : i;
        }
        catch (IllegalIDException iie) {
            return;
        }
        EmblCDROMIndexStoreTest.fail((String)"Expected IllegalIDException");
    }

    public void testGetFiles() {
        Set files = this.emblCDIndexStore.getFiles();
        HashSet<String> names = new HashSet<String>();
        names.add("protDB1.aa");
        names.add("protDB2.aa");
        names.add("protDB3.aa");
        for (String name : files) {
            EmblCDROMIndexStoreTest.assertTrue((boolean)names.contains(name));
        }
    }

    public void testGetFormat() {
        EmblCDROMIndexStoreTest.assertEquals((Object)this.format, (Object)this.emblCDIndexStore.getFormat());
    }

    public void testGetIDs() {
        Set ids = this.emblCDIndexStore.getIDs();
        EmblCDROMIndexStoreTest.assertTrue((30 == ids.size() ? 1 : 0) != 0);
    }

    public void testGetName() {
        EmblCDROMIndexStoreTest.assertEquals((String)"protDB", (String)this.emblCDIndexStore.getName());
    }

    public void testGetSBFactory() {
        EmblCDROMIndexStoreTest.assertEquals((Object)this.factory, (Object)this.emblCDIndexStore.getSBFactory());
    }

    public void testGetSymbolParser() {
        EmblCDROMIndexStoreTest.assertEquals((Object)this.parser, (Object)this.emblCDIndexStore.getSymbolParser());
    }

    public void testRollback() {
        this.emblCDIndexStore.rollback();
    }

    public void testStore() {
        try {
            this.emblCDIndexStore.store(new SimpleIndex(new File("dummy"), 0L, -1, "dummyID"));
        }
        catch (BioException be) {
            return;
        }
        EmblCDROMIndexStoreTest.fail((String)"Expected BioException");
    }
}

