/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.SequenceTools;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class TestHashSequenceDB
extends TestCase {
    private HashSequenceDB hashSequenceDB = null;
    private HashSequenceDB hashSequenceDB2 = null;
    private Sequence seq = null;

    public TestHashSequenceDB(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.hashSequenceDB = new HashSequenceDB();
        this.hashSequenceDB2 = new HashSequenceDB(new IDMaker.ByURN(), "seqDB");
        SymbolList syms = ProteinTools.createProtein("hgfds");
        Sequence seq = SequenceTools.createSequence(syms, "urn:biojava:bar", "bar", Annotation.EMPTY_ANNOTATION);
        this.hashSequenceDB.addSequence(seq);
        this.hashSequenceDB2.addSequence(seq);
    }

    protected void tearDown() throws Exception {
        this.hashSequenceDB = null;
        super.tearDown();
    }

    public void testAddSequence1() throws ChangeVetoException {
        String id = "myseq";
        this.hashSequenceDB.addSequence(id, this.seq);
        this.hashSequenceDB2.addSequence(id, this.seq);
    }

    public void testGetName() {
        String expectedReturn = "seqDB";
        String actualReturn = this.hashSequenceDB2.getName();
        TestHashSequenceDB.assertEquals((String)"return value", (String)expectedReturn, (String)actualReturn);
    }

    public void testGetSequence() throws IllegalIDException {
        String id = "bar";
        String urn = "urn:biojava:bar";
        Sequence s = this.hashSequenceDB.getSequence(id);
        if (s == null) {
            TestHashSequenceDB.fail((String)("no sequence returned for :" + id));
        }
        TestHashSequenceDB.assertTrue((boolean)s.getName().equals(id));
        s = this.hashSequenceDB2.getSequence(urn);
        if (s == null) {
            TestHashSequenceDB.fail((String)("no sequence returned for :" + urn));
        }
        TestHashSequenceDB.assertTrue((boolean)s.getURN().equals(urn));
    }

    public void testIds() {
        Set ids = this.hashSequenceDB.ids();
        TestHashSequenceDB.assertNotNull((Object)ids);
        TestHashSequenceDB.assertTrue((boolean)ids.contains("bar"));
        TestHashSequenceDB.assertTrue((ids.size() == 1 ? 1 : 0) != 0);
        ids = this.hashSequenceDB2.ids();
        TestHashSequenceDB.assertNotNull((Object)ids);
        TestHashSequenceDB.assertTrue((boolean)ids.contains("urn:biojava:bar"));
        TestHashSequenceDB.assertTrue((ids.size() == 1 ? 1 : 0) != 0);
    }

    public void testRemoveSequence() throws BioException, ChangeVetoException {
        String id = "bar";
        String urn = "urn:biojava:bar";
        this.hashSequenceDB.removeSequence(id);
        this.hashSequenceDB2.removeSequence(urn);
        TestHashSequenceDB.assertFalse((boolean)this.hashSequenceDB.ids().contains(id));
        TestHashSequenceDB.assertFalse((boolean)this.hashSequenceDB.ids().contains(urn));
        TestHashSequenceDB.assertTrue((this.hashSequenceDB.ids().size() == 0 ? 1 : 0) != 0);
        TestHashSequenceDB.assertTrue((this.hashSequenceDB2.ids().size() == 0 ? 1 : 0) != 0);
    }

    public void testSequenceIterator() {
        SequenceIterator iter = this.hashSequenceDB.sequenceIterator();
        TestHashSequenceDB.assertNotNull((Object)iter);
        Sequence s = null;
        try {
            s = iter.nextSequence();
        }
        catch (BioException ex) {
            TestHashSequenceDB.fail((String)ex.getMessage());
        }
        catch (NoSuchElementException ex) {
            ex.getMessage();
        }
        TestHashSequenceDB.assertNotNull((Object)s);
        TestHashSequenceDB.assertFalse((boolean)iter.hasNext());
    }

    public void testSerialization() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.hashSequenceDB);
        oos.writeObject(this.hashSequenceDB2);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        HashSequenceDB seqdb = (HashSequenceDB)ois.readObject();
        HashSequenceDB seqdb2 = (HashSequenceDB)ois.readObject();
        bais.close();
        ois.close();
        oos.close();
        baos.close();
        Sequence s = null;
        try {
            TestHashSequenceDB.assertNotNull((Object)seqdb);
            s = seqdb.getSequence("bar");
            TestHashSequenceDB.assertNotNull((Object)s);
        }
        catch (IllegalIDException ex) {
            TestHashSequenceDB.fail((String)ex.getMessage());
        }
        try {
            TestHashSequenceDB.assertNotNull((Object)seqdb2);
            s = seqdb2.getSequence("urn:biojava:bar");
            TestHashSequenceDB.assertNotNull((Object)s);
        }
        catch (IllegalIDException ex1) {
            TestHashSequenceDB.fail((String)ex1.getMessage());
        }
    }
}

